'use strict';

window.egopay = {
    /* адреса для обработки */
    _processUrl: '',
    _resultUrl: '',
    _secureUrl: '',
    /* данные для отправки */
    _cardData: {},
    /* уникальный id для формы */
    /* элементы страницы */
    _elements: {},
    /* таймаут запросов */
    _timeout: 10000,
    /* количество попыток повторной отправки */
    _repeatCount: 2,
    /* таймаут повторных запросов */
    _repeatTimeout: 5000,
    locale: {},
    version: 1.2,
    saved_bin: '',
    saved_bank: '',
    c2bmemers: '',
    sbpErrorTimerID: 0,

    // клиент закрыл окно
    CANCEL_CLIENT: 0,
    // по таймеру
    CANCEL_TIMER: 1,
    // по нажатию на обновление
    CANCEL_REFRESH: 2,

    /* адреса */
    setUrl: function(url) {
        this._processUrl = url;
        this._secureUrl = url.replace(/\/(card|test)\/process/gi, '/$1/secure');
        this._resultUrl = url.replace(/\/(card|test)\/process/gi, '/$1/result');
        return this;
    },

    /* данные */
    setData: function(data) {
        this._cardData = data;
        return this;
    },

    /* задаём элементы формы */
    setElements: function(form, loader, fail) {
        this._elements = {'form' : form, 'loader': loader, 'fail': fail};
        return this;
    },

    /* сообщение об ошибке при отправке ajax-запроса */
    _fail: function(textStatus, errorThrown) {
        $(window).off('beforeunload');
        if (window.pm) {
            window.pm({
                target: window.parent,
                type: 'EgoIframeError',
                data: {
                    'textStatus': textStatus,
                    'errorThrown': errorThrown
                }
            });
        }
        if (window.egopay._elements.form) {
            window.egopay._elements.form.hide();
        }
        if (window.egopay._elements.loader) {
            window.egopay._elements.loader.hide();
        }
        if (window.egopay._elements.fail) {
            if (window.egopay.locale[textStatus.toLowerCase()]) {
                window.egopay._elements.fail.find('p').show().text(window.egopay.locale[textStatus.toLowerCase()]);
            } else {
                window.egopay._elements.fail.find('p').show().text(window.egopay.locale.fatal);
            }

            window.egopay.showElement('fail');
        }
    },

    /* для вывода сообщений */
    _show: function() {
        if (window.egopay._elements.form) {
            window.egopay._elements.form.hide();
        }
        if (window.egopay._elements.fail) {
            window.egopay._elements.fail.hide();
        }
        window.egopay.showElement('loader');
    },


    /* оповестить о готовности */
    sayReady: function() {

        window.egopay.setValidate();
        window.egopay.showForm();

    },

    showForm: function() {
        window.egopay.showElement('form');
        if (window.egopay._elements.loader) {
            window.egopay._elements.loader.hide();
        }
    },

    showPaymentError: function() {
        var errorMessage = '<div id="errorMessage" style="position: absolute; right: 0; top: -75px; background: red; padding: 20px; border-radius: 5px; color: #fff"; z-index:1;>';
        errorMessage += window.egopay.locale.paymentError;
        errorMessage += '</div>';
        $('#main-cont').css('position','relative');
        $('#main-cont').append($(errorMessage));
    },

    getCardType: function(cardNumber) {

        var cards = [
            {
                type: 'visa',
                startsWith: /^4/, // начинается с 4
                length: [13, 14, 15, 16, 17, 18, 19],
                cvc: [3]
            },
            {
                type: 'dinersclub',
                startsWith: /^(3(6|8|9|0[0-5]|09)|6011)/, // начинается с 36, 38, 39, 300-305, 309, 6011
                length: [14],
                cvc: [3]
            },
            {
                type: 'amex',
                startsWith: /^3(4|7)/, // начинается с 34, 37
                length: [15],
                cvc: [4]
            },
            {
                type: 'mir',
                startsWith: /^(220[0-4])/,
                length: [16, 17, 18, 19],
                cvc: [3]
            },
            {
                type: 'mastercard',
                startsWith: /^(5[1-5]|2(22[1-9]|2[3-9]|[3-6]|7[0-1]|720))/,
                length: [16],
                cvc: [3]
            },
            {
                type: 'jcb',
                startsWith: /^(2131|1800)/, // начинается с 2131, 1800
                length: [15],
                cvc: [3]
            },
            {
                type: 'jcb',
                startsWith: /^35([3-8]|2[8-9])/, // начинается с 353-358, 3528-3529
                length: [16],
                cvc: [3]
            },
            {
                type: 'master',
                startsWith: /^(5[1-5]|2[2-7])/, // начинается с 51-55, 22-27
                length: [16],
                cvc: [3]
            },
            {
                type: 'cup',
                startsWith: /^62/, // начинается с 62
                length: [16, 17, 18, 19],
                cvc: false
            },
            {
                type: 'maestro',
                startsWith: /^5(0|[6-9])/, // начинается с 50, 56-59
                length: [12, 13, 14, 15, 16, 17, 18, 19],
                cvc: [3]
            },
            {
                type: 'maestro',
                startsWith: /^6(?!(011|2|5))/, // начинается с 6, но не 6011, 62, 65
                length: [12, 13, 14, 15, 16, 17, 18, 19],
                cvc: false
            }
        ];

        if ($('#cardcctype').val() !== undefined) {
            var selected_cardtype = $('#cardcctype').val();
            var requiredCard;
            for (var i = 0; i < cards.length; i++) {
                if (cards[i].type === selected_cardtype){
                    requiredCard = cards[i]
                }
            }
            return requiredCard;
        }


        cards = window.exception_card.concat(cards);
        for (var i = 0; i < cards.length; i++) {
            if (RegExp(cards[i].startsWith).test(cardNumber)) {
                return cards[i];
            }
        }

        return {
            type: 'unknown',
            length: [16],
            cvc: [3, 4]
        };
    },

    setValidate: function() {
        var submitEvent = false;
        var fullCard = $('#cardccnumber').is(':visible') || $('#cc_part1').length === 0;

        $('.contact_info').hide();
        $('.contact_email').hide();
        $('.contact_phone').hide();

        if (window.show_phone === "True" || window.show_email === "True"){
            $('.contact_info').show();
            if (window.show_phone === "True") {
                $('.contact_phone').show();
            }
            if (window.show_email === "True") {
                $('.contact_email').show();
            }
        }

        var contactPhone = $('.contact_phone').is(':visible');

        function togglePhone() {
            if (contactPhone) {
                return;
            }
            var c = window.egopay.getCardType(getCardNumber());
            if (c.type === 'cup') {
                $('.contact_info').show();
                $('.contact_phone').show();
            } else if (window.show_phone !== "True") {
                $('.contact_phone').hide();
            }

        }

        function getCardNumber() {
            if (fullCard || $('#cc_part1:visible').length === 0) {
                var cardccnumber = $('#cardccnumber').val() || $('#cardtoken').val() || '';
                return cardccnumber.replace(/\s/g,'').replace(/X/g,'');
            } else {
                var cardNumber = $('#cc_part1').val() + $('#cc_part2').val() + $('#cc_part3').val() + $('#cc_part4').val();
                if ($('#cc_part5').length > 0) {
                    cardNumber += $('#cc_part5').val();
                }
                return cardNumber.split(' ')[0];
            }
        }


        function allFilledWithDigits(el) {
            var filled = true;
            el.each(function(i, inp) {
                var val = $(inp).val().replace(/\s/g,'').replace(/X/g,'');
                if (!(/^\d+$/.test(val))) {
                    filled = false;
                }
            });
            return filled;
        }

        function mooncheck(num) {
            if (num.length < 12) {
                return false;
            }
            var sum = 0;
            for (var i = 0; i < num.length; i++) {
                var p = Number(num.charAt(num.length - i - 1));
                if (i % 2 !== 0) {
                    p = 2 * p;
                    if (p > 9) {
                        p = p - 9;
                    }
                }
                sum = sum + p;
            }
            return (sum % 10 === 0);
        }

        window.getLabel = function(el, cl) {
            var _for = el.hasClass('input-cardnum') ? 'cardNumber' : el.attr('id');
            _for = el.hasClass('input-expire') ? 'expireDate' : _for;

            return $('label[for="' + _for + '"]' + (cl === undefined ? '' : '.' + cl));
        };

        /* group inputs with class */
        $('#cc_part1, #cc_part2, #cc_part3').data('length', 4).attr('maxlength', 4);
        $('#cc_part4').data('length', '0-4').attr('maxlength', 4);
        $('#cc_part5').data('length', '0-3').attr('maxlength', 3);
        $('#cardccnumber').data('length', '12-19').attr('maxlength', 24); //из-за использования маски добавляются лишние пробелы
        if (fullCard) {
            $('#cardccnumber').addClass('input-cardnum');
        } else {
            $('#cc_part1, #cc_part2, #cc_part3, #cc_part4, #cc_part5').addClass('input-cardnum');
        }
        $('#cc_month, #cc_year').addClass('input-expire').data('length', 2).attr('maxlength', 2);
        $('#cardcccode').attr('maxlength', 4);
        $('#cc_part1').focus();

        /* card number validation*/
        $.validator.addMethod(
            'cardValid',
            function() {
                var cardNumber = getCardNumber(),
                    isValid = /^(\d{12,19})$/.test(cardNumber) && mooncheck(cardNumber);
                $('.input-cardnum').toggleClass('error', !isValid);
                $('#webskyx_carddata_container').toggleClass('error', !isValid);
                return isValid;
            },
            window.egopay.locale.cardNumberInvalid
        );
        /*Card type validation*/
        $.validator.addMethod(
            'cardTypeValid',
            function() {
                var cardNumber = getCardNumber(),
                    isValid = false,
                    type = window.egopay.getCardType(cardNumber).type;
                $.each(window.allow_cardtype,function(index,value){
                    if (value.toLowerCase() == type) {
                        isValid = true
                    }
                    if (value === 'American Express' && type === 'amex') {
                        isValid = true
                    }
                    if (value === 'DCL' && type === 'dinersclub') {
                        isValid = true
                    }
                })
                $('.input-cardnum').toggleClass('error', !isValid);
                $('#webskyx_carddata_container').toggleClass('error', !isValid);
                return isValid;
            },
            window.egopay.locale.cardNumberTypeInvalid
        );
         /*CVC validation*/
        $.validator.addMethod(
            'cvcLengthValid',
            function() {
                var cardtype = window.egopay.getCardType(getCardNumber()),
                    cvcLength = $('#cardcccode').val().length,
                    isValid = true;
                if ((cardtype.cvc != false) && (cardtype.cvc.indexOf( cvcLength ) == -1)) {
                    isValid = false;
                }
                $('#webskyx_carddata_container').toggleClass('error', !isValid);
                return isValid;
            },
            window.egopay.locale.cvcInvalid
        );
        /* card number required custom message */
        $.validator.addMethod(
            'cardRequired',
            function(value, inp) {
                var range = $(inp).data('length').toString().split('-');
                value = value.replace(/\s/g,'').replace(/X/g,'');
                if (range.length === 1) {
                    range[1] = range[0];
                }
                var isValid = value.length >= range[0] && value.length <= range[1];
                $('#webskyx_carddata_container').toggleClass('error', !isValid);
                return isValid;
            },
            window.egopay.locale.cardNumberRequired
        );

        /* card holder's name validation */
        $.validator.addMethod('cardHolder', function(value) {
            var reg = /^([A-Za-z.'\-]{1,32} +[A-Za-z.'\-]{1,32} *[A-Za-z]{0,32})$/;
            var isValid = reg.test(value);
            return isValid;
          },
          window.egopay.locale.cardHolderValid
        );

        /* expire date validation */
        $.validator.addMethod('expireDate',
            function() {
                var year = Number($('#cc_year').val()),
                    month = Number($('#cc_month').val()),
                    nowDate = new Date(),
                    nowYear = Number(nowDate.getFullYear()) - 2000,
                    result = false;

                if ((year === '') || (month === '')) {
                    result = true;
                }

                var cardtype = window.egopay.getCardType(getCardNumber()).type;
                var allow_expired = window.card_rules[cardtype] && window.card_rules[cardtype]['allow_expired'] == 'True';

                if (year === nowYear) {
                    if (month >= nowDate.getMonth() + 1 || allow_expired) {
                        result = true;
                    }
                } else if (year > nowYear || allow_expired) {
                    result = true;
                } else {
                    result = false;
                }

                if (month > 12 || year > 35) {
                    result = false;
                }

                $('.input-expire').toggleClass('error', !result);
                $('#webskyx_carddata_container').toggleClass('data_error', !result);
                return result;
            },
            window.egopay.locale.expireDateMustBeGreater
        );

        if (window.theme !== 'alfabank') {
            $.validator.addMethod('expireDateOneMonth',
                function() {
                    var year = Number($('#expiredate').val().split('/')[1]),
                        month = Number($('#expiredate').val().split('/')[0]),
                        nowDate = new Date(),
                        nowYear = Number(nowDate.getFullYear()) - 2000,
                        result = false;

                    if ((year === '') || (month === '')) {
                        result = true;
                    }

                    var cardtype = window.egopay.getCardType(getCardNumber()).type;
                    var allow_expired = window.card_rules[cardtype] && window.card_rules[cardtype]['allow_expired'] == 'True';

                    if (year === nowYear) {
                        if (month >= nowDate.getMonth() + 1 || allow_expired) {
                            result = true;
                        }
                    } else if (year > nowYear || allow_expired) {
                        result = true;
                    } else {
                        result = false;
                    }

                    if (month > 12 || month === 0) {
                        result = false;
                    }

                    $('.input-expire-one').toggleClass('error', !result);
                    $('#webskyx_carddata_container').toggleClass('data_error', !result);
                    return result;
                },
                window.egopay.locale.invalidMonth
            );
        }

        if (window.theme !== 'alfabank') {
            $.validator.addMethod('expireDateOneYear',
                function() {
                    var year = Number($('#expiredate').val().split('/')[1]),
                        month = Number($('#expiredate').val().split('/')[0]),
                        nowDate = new Date(),
                        nowYear = Number(nowDate.getFullYear()) - 2000,
                        result = false;

                    if ((year === '') || (month === '')) {
                        result = true;
                    }

                    var cardtype = window.egopay.getCardType(getCardNumber()).type;
                    var allow_expired = window.card_rules[cardtype] && window.card_rules[cardtype]['allow_expired'] == 'True';

                    if (year >= nowYear || allow_expired) {
                        result = true;
                    } else {
                        result = false;
                    }

                    if (year > 35) {
                        result = false;
                    }
                    $('.input-expire-one').toggleClass('error', !result);
                    $('#webskyx_carddata_container').toggleClass('error', !result);
                    return result;
                },
                window.egopay.locale.invalidYear
            );
        }

        // $.validator.addMethod("expireDateSelect",
        //     function() {
        //         var year = parseInt($("#expire_dateccexpiresyear").val(), 10),
        //             month = parseInt($("#expire_dateccexpiresmonth").val(), 10),
        //             nowDate = new Date(),
        //             result = false;

        //         if (year > nowDate.getFullYear() && year <= 2032) {
        //             result = true;
        //         }

        //         $(".input-expire-select").toggleClass("error", !result);
        //         $(".input-expire-one").toggleClass("error", !result);
        //         return result;
        //     },
        //     window.egopay.locale.expireDateMustBeGreater
        // );

        $.validator.addMethod(
            'phone',
            function(value) {
                var val = value.replace(/[^0-9]/g, '');
                return val.length >= 10 && val.length <= 15 && !(/[^0-9 \+\-\(\)]/gi.test(value));
            },
            window.egopay.locale.phoneInvalid
        );
        $.validator.addMethod(
            'email',
            function(value) {
                var re = /^(([^<>()\[\]\"\".,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
                return value.length >= 4 && (re.test(value));
            },
            window.egopay.locale.emailInvalid
        );

        /* card number validation rules */
        $.validator.addClassRules('input-cardnum', {
            cardRequired: {
                depends: function() {
                    return submitEvent || allFilledWithDigits($('.input-cardnum:visible'));
                }
            },
            cardValid: {
                depends: function() {
                    return submitEvent || allFilledWithDigits($('.input-cardnum:visible'));
                }
            },
            cardTypeValid:{
                depends: function() {
                    return submitEvent || allFilledWithDigits($('.input-cardnum:visible'));
                }
            }
        });

        /* expire date validation rules */
        $.validator.addClassRules('input-expire', {
            expireDate: {
                depends: function() {
                    return ($('#cc_month').val() >= 1) && ($('#cc_month').val() <= 12) && $('#cc_year').val() && (submitEvent || allFilledWithDigits($('.input-expire')));
                }
            }
        });

        $.validator.addClassRules('input-expire-select', {
            expireDateSelect: true
        });

        if (window.theme !== 'alfabank') {
            $.validator.addClassRules('input-expire-one', {
                expireDateOneMonth: true,
                expireDateOneYear: true
            });
        }

        $('#paymentForm').validate({
            groups: {
                cardNumber: 'cc_part1 cc_part2 cc_part3 cc_part4 cc_part5 card.ccNumber cardnumber',
                expireDate: 'cc_Year cc_Month cc-exp-year cc_month',
                expireDateOneMonth: 'expireDate',
                expireDateOneYear: 'expireDate',
                expireDateSelect: 'expire_date.ccExpiresYear expire_date.ccExpiresMonth'
            },

            rules: {
                'cc_part1': {
                    digits: true,
                    required: true,
                    minlength: 4
                },
                'cc_part2': {
                    digits: true,
                    required: true,
                    minlength: 4
                },
                'cc_part3': {
                    digits: true,
                    required: true,
                    minlength: 4
                },
                'cc_part4': {
                    digits: true,
                    //required: true,
                    //minlength: 2
                },
                'cc_part5': {
                    digits: true
                    // required: true
                },
                'card.ccNumber': {
                    digits: true,
                    required: true,
                    minlength: 12
                },
                'cardnumber': {
                    // digits: true,
                    required: true,
                    // minlength: 12
                },
                'cc_Month': {
                    required: true,
                    range: [1, 12],
                    digits: true
                },
                'cc_Year': {
                    required: true,
                    range: [16, 35],
                    digits: true
                },
                'ccmonth': {
                    required: true,
                    range: [1, 12],
                    digits: true
                },
                'cc_month': {
                    required: true,
                    range: [1, 12],
                    digits: true
                },
                'ccyear': {
                    required: true,
                    range: [16, 35],
                    digits: true
                },
                'expireDate': {
                    required: true
                },
                'cardholder': {
                    maxlength: 30,
                    required: true,
                    cardHolder: true,
                },
                'ccname': {
                    maxlength: 30,
                    required: true,
                    cardHolder: true,
                },
                'ccHolder': {
                    maxlength: 30,
                    required: true,
                    cardHolder: true,
                },
                'card.ccCode': {
                    required: true,
                    minlength: 3,
                    maxlength: 4,
                    digits: true,
                    cvcLengthValid: true,
                },
                'cvc': {
                    required: true,
                    minlength: 3,
                    maxlength: 4,
                    digits: true,
                    cvcLengthValid: true,
                },
                'phone': {
                    required: true,
                    phone: true,
                },
                'email': {
                    required: true,
                    email: true,
                }
            },

            messages: {
                'cc_part1': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    minlength: window.egopay.locale.cardNumberRequired
                },
                'cc_part2': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    minlength: window.egopay.locale.cardNumberRequired
                },
                'cc_part3': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    minlength: window.egopay.locale.cardNumberRequired
                },
                'cc_part4': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    minlength: window.egopay.locale.cardNumberRequired
                },
                'cc_part5': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired
                },
                'card.ccNumber': {
                    digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    minlength: window.egopay.locale.cardNumberRequired
                },
                'cardnumber': {
                    // digits: window.egopay.locale.cvcDigitsOnly,
                    required: window.egopay.locale.cardNumberRequired,
                    // minlength: window.egopay.locale.cardNumberRequired
                },
                'cc_Month': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidMonth,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'cc_Year': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidYear,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'ccmonth': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidMonth,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'ccyear': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidYear,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'cc_month': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidMonth,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'cc-exp-year': {
                    required: window.egopay.locale.expireDateRequired,
                    range: window.egopay.locale.invalidYear,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'expireDate': {
                    required: window.egopay.locale.expireDateRequired,
                },
                'cardholder': {
                    required: window.egopay.locale.cardHolderRequired,
                    maxlength: window.egopay.locale.cardHolderLength
                },
                'ccHolder': {
                    required: window.egopay.locale.cardHolderRequired,
                    maxlength: window.egopay.locale.cardHolderLength
                },
                'ccname': {
                    required: window.egopay.locale.cardHolderRequired,
                    maxlength: window.egopay.locale.cardHolderLength
                },
                'card.ccCode': {
                    required: window.egopay.locale.cvcDigitsRequired,
                    minlength: window.egopay.locale.cvcInvalid,
                    maxlength: window.egopay.locale.cvcInvalid,
                    cvcLengthValid: window.egopay.locale.cvcInvalid,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'cc-csc': {
                    required: window.egopay.locale.cvcDigitsRequired,
                    minlength: window.egopay.locale.cvcInvalid,
                    maxlength: window.egopay.locale.cvcInvalid,
                    cvcLengthValid: window.egopay.locale.cvcInvalid,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'cvc': {
                    required: window.egopay.locale.cvcDigitsRequired,
                    minlength: window.egopay.locale.cvcInvalid,
                    maxlength: window.egopay.locale.cvcInvalid,
                    cvcLengthValid: window.egopay.locale.cvcInvalid,
                    digits: window.egopay.locale.cvcDigitsOnly
                },
                'phone': {
                    required: window.egopay.locale.phoneRequired,
                    phone: window.egopay.locale.phoneInvalid
                },
                'email': {
                    required: window.egopay.locale.emailRequired,
                    email: window.egopay.locale.emailInvalid
                }
            },

            showErrors: function(errorMap, errorList) {
                this.defaultShowErrors();

                if (errorList.length > 0) {
                    if (submitEvent) {
                        submitEvent = false;
                        $(errorList[0].element).focus();
                    }
                }
            },

            onkeyup: false,
            focusInvalid: false
        });

        function hint() {
            var hint_messages = {
                layout: window.egopay.locale.layout
            };

            function displayHintLabel(element, message) {
                element.parent().append('<p class="hint_label">' + message + '</p>')
            };

            function emailHintValidation(email) {
                var enLan = /[a-z]/i;
                var ruLan = /[а-я]/i;
                var en = false;
                var ru = false;
                var val = email.val();
                var Letters = /[a-zа-я]/i;
                var letter = false;
                letter = Letters.test(val);
                en = enLan.test(val);
                ru = ruLan.test(val);
                if (en === ru && letter) {
                  displayHintLabel(email, hint_messages.layout);
                };
                email.val(email.val().replace(/\s/, ''));
            };

            this.emailHintValidation = emailHintValidation;
        }

        var checkHints = new hint();
        var hintRules = {
            'email': checkHints.emailHintValidation,
        };

        function hintFields(fieldsArray) {
            var resultArray = [];
            $.each(fieldsArray, function(index, value) {
                if (hintRules[value] != undefined) {
                    if (hintRules[value]($('#' + value)) === false) {
                        resultArray.push(value);
                    }
                }
            });
            return resultArray;
        }

        var hintFieldsList = [];

        $.each($('input'), function(element, value) {
            hintFieldsList.push(value.id);
        });

        function hintLighting(fieldsArray){
            $('input').removeClass('hint_label');
            $.each(fieldsArray, function(index, value){
                $('#'+value).addClass('hint_label');
            });
        }

        $('input').on('keyup', function() {
            var parent_element = $(this).parent();
            var childerns = parent_element.children('.hint_label');
            childerns.remove();
            var elementId = $(this).attr('id');
            if ($(this).val()) {
                if (hintFieldsList.indexOf(elementId) !== -1) {
                    var items = hintFields([elementId]);
                    hintLighting(items);
                    $('.hint_label').show();
                }
            }
        });

        $('#paymentForm').on('focusin', 'input', function() {
            var el = $(this);
            if (el.hasClass('error')) {
                if ($('#paymentForm').data('validator').check(this) === false) {
                    window.getLabel(el, 'error').text( $('#paymentForm').data('validator').errorMap[el.attr('name')] );
                }

                window.getLabel(el, 'error').css('visibility', 'visible').show();
            }
        });

        $('#paymentForm').on('focusout', 'input', function() {
            window.getLabel($(this)).css('visibility', 'hidden');
        });

        $('#paymentForm input').keyup(function(e) {
            var el = $(this),
                inputs = $('#paymentForm input:enabled:visible'),
                index = inputs.index(el);

            togglePhone();
            if (el.data('length') && (el.val().length === Number(el.data('length'))) && ((e.which > 47 && e.which < 58) || (e.which > 95 && e.which < 106))) {
                if (index > -1 && (index + 1) < inputs.length) {
                    inputs.eq(index + 1).focus();
                    window.getLabel(el).css('visibility', 'hidden').hide();

                    if ($(inputs.eq(index + 1)).hasClass('error')) {
                        window.getLabel($(inputs.eq(index + 1)), 'error').css('visibility', 'visible').show();
                    }
                }
            }
        });

        $('#paymentForm input').keydown(function(e) {
            var el = $(this),
                inputs = $('#paymentForm input:enabled:visible'),
                index = inputs.index(el);
            if ((e.which === 8) && (el.val().length === 0) && (index > 0)) {
                e.preventDefault();
                inputs.eq(index - 1).focus();
            }
        });

        $('#cc_month').keyup(function(e) {
            var val = $('#cc_month').val();
            if (val.length === 1 && ((e.which >= 50 && e.which <= 57) || (e.which >= 98 && e.which <= 105))) {
                $('#cc_month').val('0' + val);
                $('#cc_year').focus();
            }
        });

        $('#cc_part1').bind('keyup', function() {
            var val = getCardNumber();
            var c = window.egopay.getCardType(val);
            var maxLength = Math.max.apply(Math, c.length);
            if (c.type === 'cup') {
                $('#cardholder').val('Unknown Holder');
                $('#expire_dateccexpiresmonth').val('12');
                $('#expire_dateccexpiresyear').val('50');
                $('#cc_month').val('12');
                $('#cc_year').val('50');
                $('.art').hide();
                $('.holder').hide();

            } else {
                $('.art').show();
                $('.holder').show();
            }
            if (maxLength > 16) {
                $('.input-cardnum').addClass('thin');
                $('#cc_part5').show();
            } else {
                $('#cc_part5').removeClass('error').val('').hide();
                $('.input-cardnum').removeClass('thin');
            }

            if (c.cvc === false) {
                $('.decor_block').css('visibility', 'hidden');
                $('#cardcccode').removeClass('error').val('').attr('disabled', 'disabled');
            } else {
                $('.decor_block').css('visibility', 'visible');
                $('#cardcccode').removeAttr('disabled');
            }
        });
        $('#cc_part2').bind('keyup', function() {
            var val = getCardNumber();
            var c = window.egopay.getCardType(val);
            var maxLength = Math.max.apply(Math, c.length);
            if (c.type === 'cup') {
                $('#cardholder').val('Unknown Holder');
                $('#expire_dateccexpiresmonth').val('12');
                $('#expire_dateccexpiresyear').val('50');
                $('#cc_month').val('12');
                $('#cc_year').val('50');
                $('.art').hide();
                $('.holder').hide();

            } else {
                $('.art').show();
                $('.holder').show();
            }
            if (maxLength > 16) {
                $('.input-cardnum').addClass('thin');
                $('#cc_part5').show();
            } else {
                $('#cc_part5').removeClass('error').val('').hide();
                $('.input-cardnum').removeClass('thin');
            }

            if (c.cvc === false) {
                $('.decor_block').css('visibility', 'hidden');
                $('#cardcccode').removeClass('error').val('').attr('disabled', 'disabled');
            } else {
                $('.decor_block').css('visibility', 'visible');
                $('#cardcccode').removeAttr('disabled');
            }
        });
        $('#cc_part3').bind('keyup', function() {
            var val = getCardNumber();
            var c = window.egopay.getCardType(val);
            var maxLength = Math.max.apply(Math, c.length);
            if (c.type === 'cup') {
                $('#cardholder').val('Unknown Holder');
                $('#expire_dateccexpiresmonth').val('12');
                $('#expire_dateccexpiresyear').val('50');
                $('#cc_month').val('12');
                $('#cc_year').val('50');
                $('.art').hide();
                $('.holder').hide();

            } else {
                $('.art').show();
                $('.holder').show();
            }
            if (maxLength > 16) {
                $('.input-cardnum').addClass('thin');
                $('#cc_part5').show();
            } else {
                $('#cc_part5').removeClass('error').val('').hide();
                $('.input-cardnum').removeClass('thin');
            }

            if (c.cvc === false) {
                $('.decor_block').css('visibility', 'hidden');
                $('#cardcccode').removeClass('error').val('').attr('disabled', 'disabled');
            } else {
                $('.decor_block').css('visibility', 'visible');
                $('#cardcccode').removeAttr('disabled');
            }
        });
        $('#cc_part4').bind('keyup', function() {
            var val = getCardNumber();
            var c = window.egopay.getCardType(val);
            var maxLength = Math.max.apply(Math, c.length);
            if (c.type === 'cup') {
                $('#cardholder').val('Unknown Holder');
                $('#expire_dateccexpiresmonth').val('12');
                $('#expire_dateccexpiresyear').val('50');
                $('#cc_month').val('12');
                $('#cc_year').val('50');
                $('.art').hide();
                $('.holder').hide();

            } else {
                $('.art').show();
                $('.holder').show();
            }
            if (maxLength > 16) {
                $('.input-cardnum').addClass('thin');
                $('#cc_part5').show();
            } else {
                $('#cc_part5').removeClass('error').val('').hide();
                $('.input-cardnum').removeClass('thin');
            }

            if (c.cvc === false) {
                $('.decor_block').css('visibility', 'hidden');
                $('#cardcccode').removeClass('error').val('').attr('disabled', 'disabled');
            } else {
                $('.decor_block').css('visibility', 'visible');
                $('#cardcccode').removeAttr('disabled');
            }
        });
        $('#cardccnumber').bind('keyup', function() {
            var val = $(this).val().replace(/\s/g,'').replace(/X/g,'');
            var c = window.egopay.getCardType(val);
            if (c.type === 'cup') {
                $('#cardholder').val('Unknown Holder');
                $('#expire_dateccexpiresmonth').val('12');
                $('#expire_dateccexpiresyear').val('50');
                $('#cc_month').val('12');
                $('#cc_year').val('50');
                $('.art').hide();
                $('.holder').hide();

            } else {
                $('.art').show();
                $('.holder').show();
            }
            if (c.cvc === false) {
                $('.decor_block').css('visibility', 'hidden');
                $('#cardcccode').removeClass('error').val('').attr('disabled', 'disabled');
                $('#webskyx_carddata_container').removeClass('error');
            } else {
                $('.decor_block').css('visibility', 'visible');
                $('#cardcccode').removeAttr('disabled');
            }
        });

        var promocode = '<label class="promo_elem"><span class="promo_delete">x</span>';
        promocode += '<input type="text" class="promo_input" /></label>';

        $("#promocode_btn").on("click", function() {
            var promocodes = $(".promocodes > *").length;
            if (!promocodes) {
                $(".promocodes").append(promocode);
                promo_delete();
            }
            $(".promocodes_container").toggleClass("hided");
        });

        $("#promocode_add").on("click", function() {
            if (
                $(".promocodes > label:last-child input").val() ||
                !$(".promocodes > *").length
            ) {
                $(".promocodes").append(promocode);
                promo_delete();
            }
        });

        function promo_delete() {
            $(".promo_delete").on("click", function() {
                $(this).parent().remove();
            });
        }

        if ($('#saved-cards option').length > 1) {

            $('#saved-cards').on('change keyup', function() {
                var newCard = $(this).val() === '',
                    code = $('option:selected', this).data('code');
                $('.card_number, .art, .holder, .decor_block_2').toggle(newCard);
                $('.decor_block').toggle(code !== 'EU');
                $('.preseted-info').toggle(!newCard);
                $('#cardccnumber').val( $(this).val() );
                fullCard = !newCard;

                if (!newCard) {
                    $('#cardholder').val('Unknown Holder');
                    $('#expire_dateccexpiresmonth').val('12');
                    $('#expire_dateccexpiresyear').val('50');
                    $('#cc_month').val('12');
                    $('#cc_year').val('50');
                    $('#cardcccode').val('');
                    $('.preseted-info tr').empty();
                    var masked = $('option:selected', this).text(),
                        maskedCardNumber = masked.slice(0, 4) + '********' + masked.slice(-4);
                    for (var i = 0; i < maskedCardNumber.length; i++) {
                        $('.preseted-info tr').append('<td>' + maskedCardNumber.charAt(i) + '</td><td>&nbsp;</td>');
                        if ((i + 1) % 4 === 0 && maskedCardNumber.length - 1 > i) {
                            $('.preseted-info tr').append('<td>&nbsp;&nbsp;</td>');
                        }
                    }
                } else {
                    $('#cardholder').val('');
                    $('#expire_dateccexpiresmonth').val('');
                    $('#expire_dateccexpiresyear').val('');
                    $('#cardcccode').val('');
                    $('#cc_month').val('');
                    $('#cc_year').val('');
                }
            });

        }

        if (window.egopay.setExtValidate) {
            window.egopay.setExtValidate();
        }

        function check_spasibo_accrual() {
            var data = {
                'card_number': getCardNumber(),
                'exp': Number($('#cc_year').val()) + 2000 + '' + $('#cc_month').val()
            }
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/index/gi, '/$1/get_sbrf_spasibo_bonus_range'),
                type: 'POST',
                data: JSON.stringify(data),
                dataType: 'json',
                contentType: 'application/json',
            });
        }

        function checkExpAlfa() {
            var year = Number($('#expiredate').val().split('/')[1]),
                month = Number($('#expiredate').val().split('/')[0]),
                nowDate = new Date(),
                nowYear = Number(nowDate.getFullYear()) - 2000,
                result = false;

            if ((year === '') || (month === '')) {
                result = true;
            }

            var cardtype = window.egopay.getCardType(getCardNumber()).type;
            var allow_expired = window.card_rules[cardtype] && window.card_rules[cardtype]['allow_expired'] == 'True';

            if (year === nowYear) {
                if (month >= nowDate.getMonth() + 1 || allow_expired) {
                    result = true;
                }
            } else if (year > nowYear || allow_expired) {
                result = true;
            } else {
                result = false;
            }

            if (month > 12 || year > 35) {
                result = false;
            }

            if (!result) {
                $('.notification').show().addClass('notification_visible');
                // setTimeout(function() {
                //    $('.notification').removeClass('notification_visible').hide()
                // }, 1000 * 5)
            }
            return result;
        }
        $('#paymentForm').submit(function() {
            $('#errorMessage').remove();
            submitEvent = true;
            $(this).valid(); // fix submit by enter press
            submitEvent = true;
            if (!($(this).valid())) {
                submitEvent = true;
                return false;
            } else if (window.theme === 'alfabank' && !checkExpAlfa()) {
                return false;
            } else {
                $('.binded').hide();
                var month = 0,
                    year = 0;

                if ($('#cc_month').length === 1) {
                    month = Number($('#cc_month').val());
                    year = Number($('#cc_year').val()) + 2000;
                } else if ($('#expiredate').length > 0) {
                    year = Number($('#expiredate').val().split('/')[1]) + 2000;
                    month = Number($('#expiredate').val().split('/')[0]);
                } else {
                    month = Number($('#expire_dateccexpiresmonth').val());
                    year = Number($('#expire_dateccexpiresyear').val()) + 2000;
                }
                var _url = $('#paymentForm').attr('action'),
                    _data = {
                        'expire_date.ccExpiresMonth': month,
                        'expire_date.ccExpiresYear': year,
                        'card.ccNumber': getCardNumber(),
                        'ccHolder': $('#ccholder').val() || $('#cardholder').val(),
                        'save': $('#save_card').is(':checked')
                    };
                if ($("div").is('#moto')==false){
                    _data['card.ccCode'] = $('#cardcccode').val();
                }

                if ($('#cardcctype').length === 1) {
                    _data['card.ccType'] = $('#cardcctype').val();
                }

                if ($('#email:visible').length === 1) {
                    _data.email = $('#email').val();
                }

                if ($('#phone:visible').length === 1) {
                    // var phone = $('#phone').val().replace(/\s/g, '');
                    var phone = $('#phone').val().replace(/[^0-9]/g, '').replace(/^0+/g, '');
                    _data.phone = phone;
                }

                if ($("input").is('#bhname') && $('#bhname').val().length > 1){
                     _data['bhfirst_name'] = $('#bhname').val().trim();
                }

                if ($("input").is('#bhsecond_name') && $('#bhsecond_name').val().length > 1){
                     _data['bhsecond_name'] = $('#bhsecond_name').val().trim();
                }

                if ($("input").is('#bcnumber') && $('#bcnumber').val().length > 1){
                     _data['bcnumber'] = $('#bcnumber').val();
                     _data['bctype'] = $('#bonus').attr('type');
                     _data['bcoperation_type'] = $('#bonus').attr('operation_type');
                     _data['bcamount'] = $('#bonus').attr('amount');
                }
                if (window.spasibo == 'True' && $('.order_desc__amount').html()) {
                    _data['spasibo_accrual_amt'] = parseFloat($('.order_desc__amount').html().split(' руб')[0]) - $('#spasibo_val').val();
                    if ($('.spasibo_main_block').is(':visible')) {
                        if ($(window).width() > 800) {
                            if ($('#range').val() != 0) {
                                _data['spasibo_withdrawal_amt'] = $('#range').val();
                            }
                        } else {
                            if ($('#spasibo_val_mobile').val() != 0) {
                                _data['spasibo_withdrawal_amt'] = $('#range').val();
                            }
                        }
                    }
                }

                var promocodes = [];
                var promoNodes = document.getElementsByClassName('promo_input');

                for (var i = 0; i < promoNodes.length; i++ ) {
                    promocodes.push(promoNodes[i].value)
                }

                var filtered = promocodes.filter(function(promo) {
                    return promo !== "";
                });

                if (promocodes.length) {
                    _data['promocodes'] = filtered;
                }

                if (window.certificate) {
                    _data['promocodes'] = [window.certificate];
                }

                window.egopay.setUrl(_url).setData(_data).process();
                return false;
            }
        });

        $('.sbp').on('click', function() {
            $('.sbp').off('click');
            window.egopay.handleSbp();
        });
    },

    handleSbp: function() {
        if ($('#qrcode').length) {
            $('.sbp__modal').addClass('sbp__modal-visible');
            return
        }
        $('#errorMessage').remove();
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/sbp'),
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            success: function(data){
                clearTimeout(window.egopay.sbpErrorTimerID);
                if (!data.error) {
                    window.egopay.showSbpModal(data)
                } else {
                    window.egopay.showSbpError(true)
                }
            },
            error: function() {
                clearTimeout(window.egopay.sbpErrorTimerID);
                window.egopay.showSbpError(false)
            }
        })
    },


    showSbpError: function(disable) {
        var error = $("<span id='errorMessage' style='color:red;position:absolute;bottom:-30px;font-size:13px;'>Оплата по QR коду временно не доступна</span>")
        if (window.theme !== 'pobeda') {
            $(".sbp").append( error );
        } else {
            $('.sbp-qr_tip-mobile').hide();
            $('.sbp-qr_tip').hide();
            $(".sbp-error_message").show();
        }
        if ( disable ) {
            $(".sbp").addClass('sbp_disabled');
        }
    },

    showSbpModal: function(data) {
        $('.sbp-timeout_message').hide();
        $('.sbp-error_message').hide();
        $('.sbp-qr_tip').hide();
        if (window.egopay.isMobile.any()) {
            var href = data.url.replace(/https/,'');
            var modal = '<div id="sbp-mobile-modal">';
            modal += '<div class="slide-up-widget">';
            modal += '<div class="slide-up-widget__header">';
            modal += '<img src="https://sbp.nspk.ru/i/logo-black.svg" class="slide-up-widget__header-image">';
            modal += '<div class="slide-up-widget__header-close-btn">×</div>';
            modal += '<div class="slide-up-widget__header-text">Подтвердите оплату в Вашем банковском приложение</div>';
            modal += '</div>';
            modal += '<input placeholder="Поиск" class="slide-up-widget__input">';
            for (var i = 0; i < window.egopay.c2bmemers.length; i++) {
                var link = '';
                if (window.egopay.isMobile.iOS()) {
                    link = window.egopay.c2bmemers[i].schema + href
                } else if (window.egopay.isMobile.Android()) {
                    link = 'intent' + href + '#Intent;scheme='+window.egopay.c2bmemers[i].schema+';end';
                }
                modal += '<a class="slide-up-widget__bank" href="'+link+'">';
                modal += '<img class="slide-up-widget__bank-logo" src="'+window.egopay.c2bmemers[i].logoURL+'">';
                modal += '<div class="slide-up-widget__bank-title">'+window.egopay.c2bmemers[i].bankName+'</div>';
                modal += '</a>';
            }
            modal += '</div>';
            modal += '</div>';
            $('body').append(modal);
            $('.sbpMobileWrapp').show();
            $('.sbp-qr_tip-mobile').hide();
            $('.slide-up-widget__header-close-btn').on('click', function() {
                $('#sbp-mobile-modal').remove();
                $('.sbp').on('click', window.egopay.handleSbp);
            });
            $('.slide-up-widget__input').on('keyup', function() {
                var name = $('.slide-up-widget__input').val().toLowerCase();
                $('.slide-up-widget__bank').remove();
                for (var i = 0; i < window.egopay.c2bmemers.length; i++) {
                    if (window.egopay.c2bmemers[i].bankName.toLowerCase().indexOf(name) !== -1) {
                        var link = '';
                        if (window.egopay.isMobile.iOS()) {
                            link = window.egopay.c2bmemers[i].schema + href
                        } else if (window.egopay.isMobile.Android()) {
                            link = 'intent' + href + '#Intent;scheme='+window.egopay.c2bmemers[i].schema+';end';
                        }
                        var bank = '';
                        bank += '<a class="slide-up-widget__bank" href="'+link+'">';
                        bank += '<img class="slide-up-widget__bank-logo" src="'+window.egopay.c2bmemers[i].logoURL+'">';
                        bank += '<div class="slide-up-widget__bank-title">'+window.egopay.c2bmemers[i].bankName+'</div>';
                        bank += '</a>';
                        $('.slide-up-widget').append(bank);
                    }
                }
            })
        } else {
            if (window.theme !== 'pobeda') {
                $('.sbp__modal').remove();
                var modal = '<div class="modal sbp__modal">';
                modal += '<button role="button" type="button" class="modal_btn-close"></button>';
                modal += '<div class="modal__content">';
                modal +=    '<div class="qr_container"></div>';
                modal +=    '<p class="qr_text">';
                modal +=        '<a tabindex="0" id="qr_link" class="qr_link" rel="noreferrer noopener" href="#" target="_blank">Оплатить по ссылке</a>';
                modal +=    '</p>';
                modal +=    '</div>';
                modal += '</div>';
                $('#paymentForm').append(modal);
                $('.modal_btn-close').on('click', function() {
                    $('.sbp__modal').removeClass('sbp__modal-visible');
                    $('.sbp').on('click', window.egopay.handleSbp);
                });
                $('.sbp__modal').addClass('sbp__modal-visible');
                $('#qr_link').attr('href', data.url);
            }
            var qrCont = document.createElement('div');
            qrCont.id = 'qrcode';
            $('.qr_container').empty();
            document.getElementsByClassName('qr_container')[0].appendChild(qrCont);
            if(data.data && data.data_type) {
                var sbpImg = document.createElement('img');
                sbpImg.src = 'data:' + data.data_type + ';base64,' + data.data;
                document.getElementById('qrcode').appendChild(sbpImg);
            } else {
                var qrcode = new QRCode(document.getElementById('qrcode'), {
                    text: data.url,
                    colorDark : '#000',
                    colorLight : '#fff',
                    correctLevel : QRCode.CorrectLevel.H
                });
            }
        }
        window.egopay.getSbpStatus();
    },

    getSbpStatus: function() {
        var sbp_status_interval = setInterval(function() {
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/sbp_status'),
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                success: function(data){
                    // if (data.error) {
                    //     clearInterval(sbp_status_interval);
                    //     $("sbp__modal").removeClass('sbp__modal-visible');
                    //     window.egopay.showSbpError(false);
                    //     $('.sbp').on('click', window.egopay.handleSbp);
                    // } else
                    if (data.status !== 'in_progress' && data.status !== 'created' && !data.error) {
                        $(window).off('beforeunload');
                        clearInterval(sbp_status_interval);
                        var sbp_url = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/sbp/result')+'?action=' + data.status
                        window.location.replace(sbp_url);
                    }
                }
            });
        }, 3000)
    },

    _repeat: function() {
        setTimeout(
            function() {
                window.egopay._repeatCount--;
                window.egopay._process();
            },
            window.egopay._repeatTimeout
        );
    },

    _expired: function() {
        $('.input-expire, .input-expire-one').toggleClass('error');
        $('#webskyx_carddata_container').toggleClass('error');
        $('.input-expire, .input-expire-one').parent().append(
            '<label for="expireDate" class="error" style="visibility: visible; display: inline;">' + window.egopay.locale.invalidExpDate + '</label>'
        );
        $('.binded').show();
        window.egopay.showForm();
    },

    process: function() {
        if (window.pm) {
            window.pm({
                target: window.parent,
                type: 'EgoIframeProcess',
                data: ''
            });
        }
        window.egopay._process();
    },

    /* авторизация */
    _process: function() {
        this._show();

        /* шаг 1 */
        $.ajax({
            url: this._processUrl,
            type: 'POST',
            data: JSON.stringify(this._cardData),
            dataType: 'json',
            contentType: 'application/json',
            traditional: false,
            cache: false,
            error: function(jqXHR, textStatus, errorThrown) {
                if (!window.egopay._repeatCount) {
                    window.egopay._fail(textStatus, errorThrown);
                    return;
                }
                window.egopay._repeat();
            },
            success: function(data) {
                if (data.paymentMethod && data.paymentMethod === 'cup') {
                    window.egopay.unionpay(data.url, data.data);
                    return;
                }

                if (!('result' in data) || $.inArray(data.result, ['system/in_progress', 'system/error']) > -1) {
                    if (!window.egopay._repeatCount) {
                        window.egopay._fail('timeout', 'system/error');
                        return;
                    }

                    window.egopay._repeat();
                    return;
                }

                if (data.result === 'system/session') {
                    window.egopay._fail('error', 'system/session');
                    window.alive.stop();
                    return;
                }

                if (data.result === 'system/expired_card') {
                    window.egopay._expired();
                    return;
                }

                if (data.result !== 'system/ok') {
                    window.egopay._fail('error', data.result);
                    return;
                }

                window.egopay.secure();
            },
            timeout: this._timeout
        });
    },

    unionpay: function(url, data) {
        $(window).off('beforeunload');
        $('body').append('<form id="cupform" method="post" />');
        $('#cupform').attr('action', url);
        var inp_month,inp_year;

        inp_month = $('<input type="hidden" />');
        inp_month.attr('name', 'cc_month');
        inp_month.val('12');
        $('#cupform').append(inp_month);

        inp_year = $('<input type="hidden" />');
        inp_year.attr('name', 'cc_year');
        inp_year.val('50');
        $('#cupform').append(inp_year);



        var i, inp;
        for (i in data) {
            if (data[i] !== null) {
                inp = $('<input type="hidden" />');
                inp.attr('name', i);
                inp.val(data[i]);


                $('#cupform').append(inp);
            }
        }
        $('#cupform').submit();
    },

    ukreximbank: function(url, data) {
        $(window).off('beforeunload');
        $('body').append('<form id="ukreximbank" method="post" />');
        $('#ukreximbank').attr('action', url);

        var i, inp;
        for (i in data) {
            if (data[i] !== null) {
                inp = $('<input type="hidden" />');
                inp.attr('name', i);
                inp.val(data[i]);


                $('#ukreximbank').append(inp);
            }
        }
        $('#ukreximbank').submit();
    },

    secure: function() {
        $(window).off('beforeunload');
        window.location.replace(window.egopay._secureUrl);
    },

    setLocale: function(locale) {
        this.locale = locale;
    },

    confirmClose: function() {
        var notEmpty;
        $('#paymentForm :input:visible').each(function(i, item) {
            if (!notEmpty && $(item).val() !== '') {
                notEmpty = true;
            }
        });
        if (notEmpty) {
            return window.egopay.locale.navigateAway;
        }
    },
    inIframe: function() {
        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    },
    samsungpayProcess: function(inframe) {
        $("#samsungpay").off('click');
        $('#errorMessage').remove();
        var transactionRequest = {};
        if (inframe) {
            var topLocation = window.parent.location;
            if (window.egopay.topLocation.indexOf('?') !== -1) {
                transactionRequest.callback = window.egopay.topLocation + '&pg=samsungpay';
            } else {
                transactionRequest.callback = window.egopay.topLocation + '?pg=samsungpay';
            }
        } else {
            transactionRequest.callback = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/samsungpay_process');
        }
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/samsungpay_transaction'),
            type: 'POST',
            dataType: 'json',
            data: JSON.stringify(transactionRequest),
            contentType: 'application/json',
            success: function(data){
                $(window).off('beforeunload');
                $("#samsungpay").on("click", function() {
                    window.egopay.samsungpayProcess(inframe)
                });
                if (inframe) {
                    data.callback = transactionRequest.callback;
                    data.cancelUrl = transactionRequest.callback + '&pg_action=cancel';
                    if (window.pm) {
                        window.pm({
                            target: window.parent,
                            type: 'samsungPayButtonPressed',
                            data: data
                        });
                    }
                } else {
                    SamsungPay.connect(
                        data.result.id,
                        data.result.href,
                        data.result.serviceId,
                        transactionRequest.callback,
                        window.location.toString() + '?gateway_error=1',
                        data.result.countryCode,
                        data.result.encInfo.mod,
                        data.result.encInfo.exp,
                        data.result.encInfo.keyId
                    );
                }
            },
            error: function() {
                $("#samsungpay").on("click", function() {
                    window.egopay.samsungpayProcess(inframe)
                });
            }
        });
    },
    getDeviceInfo: function() {
        var userAgent = navigator.userAgent.toLowerCase();
        var type, os, vendor, applepaySupport = false, googlepaySupport = false, yandexpaySupport = false;
        var isTablet = /(ipad|tablet|(android(?!.*mobile))|(windows(?!.*phone)(.*touch))|kindle|playbook|silk|(puffin(?!.*(IP|AP|WP))))/.test(userAgent);
        var osxVer = userAgent.match(/os x (\d+)[_.](\d+)/);
        if (osxVer) {
            osxVer = osxVer[1]+"."+osxVer[2];
        }

        var browserName = 'unknown';
        if (/^((?!chrome|android|crios).)*safari/i.test(userAgent)){
            browserName = 'safari';
        }

        if ( isTablet ) {
            type = 'tablet';
        } else {
            if ( window.innerWidth < 768 ) {
                type = 'mobile';
            } else {
                type = 'desktop';
            }
        }
        if ( userAgent.indexOf("android") > -1 ) {
            os = 'android';
        } else if ( /iPad|iPhone|iPod|Mac/i.test(userAgent) && !window.MSStream ) {
            os = 'ios';
        } else {
            os = 'unknown';
        }
        if ( userAgent.match(/SAMSUNG|SGH-[I|N|T]|GT-[I|P|N]|SM-[N|P|T|Z|G]|SHV-E|SCH-[I|J|R|S]|SPH-L|SM-[A]/i) ) {
            vendor = 'samsung';
        } else {
            vendor = 'unknown';
        }
        if (window.ApplePaySession) {
            applepaySupport = true;
        }
        if (window.googlePaySettings) {
            googlepaySupport = true;
        }
        if (window.yandexpaySettings) {
            yandexpaySupport = true;
        }
        return {
            type: type,
            os: os,
            vendor: vendor,
            applepaySupport: applepaySupport,
            googlepaySupport: googlepaySupport,
            yandexpaySupport: yandexpaySupport,
            osxVer: osxVer,
            browserName: browserName
        };
    },
    detectPgRules: function(device) {
        var applepay, googlepay, samsungpay, yandexpay;
        if ( !window.pgDisplayRules ) {
            if ( device.applepaySupport ) {
                applepay = true;
            }
            if ( device.googlepaySupport ) {
                googlepay = true;
            }
            if ( device.yandexpaySupport ) {
                yandexpay = true;
            }
            samsungpay = true;
        } else {
            var appleSettings = window.pgDisplayRules.applepay;
            var googleSettings = window.pgDisplayRules.googlepay;
            var samsungSettings = window.pgDisplayRules.samsungpay;
            var yandexSettings = window.pgDisplayRules.yandexpay;
            if ( !appleSettings ) {
                if ( device.applepaySupport ) {
                    applepay = true;
                }
            } else if ( appleSettings[device.type] && RegExp(appleSettings.browserName).test(device.browserName) && RegExp(appleSettings.os).test(device.os) && ( appleSettings.vendor == 'all' || appleSettings.vendor == device.vendor ) && device.applepaySupport) {
                applepay = true;
                if (device.osxVer && device.osxVer < 10.14){
                    applepay = false;
                } else {
                    if ( appleSettings.theOnlyOne ) {
                        return { applepay: applepay, samsungpay: samsungpay, googlepay: googlepay, yandexpay: yandexpay };
                    }
                }
            }
            if ( !samsungSettings ) {
                samsungpay = true;
            } else if ( samsungSettings[device.type] && RegExp(samsungSettings.browserName).test(device.browserName) && RegExp(samsungSettings.os).test(device.os) && ( samsungSettings.vendor == 'all' || samsungSettings.vendor == device.vendor ) ) {
                samsungpay = true;
                if ( samsungSettings.theOnlyOne ) {
                    applepay = false;
                    return { applepay: applepay, samsungpay: samsungpay, googlepay: googlepay, yandexpay: yandexpay };
                }
            }
            if ( !googleSettings ) {
                if ( device.googlepaySupport ) {
                    googlepay = true;
                }
            } else if ( googleSettings[device.type] && RegExp(googleSettings.browserName).test(device.browserName) && RegExp(googleSettings.os).test(device.os) && ( googleSettings.vendor == 'all' || googleSettings.vendor == device.vendor ) && device.googlepaySupport ) {
                googlepay = true;
                if ( googleSettings.theOnlyOne ) {
                    applepay = false;
                    samsungpay = false;
                    return { applepay: applepay, samsungpay: samsungpay, googlepay: googlepay, yandexpay: yandexpay };
                }
            }
            if ( !yandexSettings ) {
                if ( device.yandexpaySupport ) {
                    yandexpay = true;
                }
            } else if ( yandexSettings[device.type] && RegExp(yandexSettings.browserName).test(device.browserName) && RegExp(yandexSettings.os).test(device.os) && ( yandexSettings.vendor == 'all' || yandexSettings.vendor == device.vendor ) && device.yandexpaySupport ) {
                yandexpay = true;
                if ( yandexSettings.theOnlyOne ) {
                    applepay = false;
                    samsungpay = false;
                    googlepay = false;
                    return { applepay: applepay, samsungpay: samsungpay, googlepay: googlepay, yandexpay: yandexpay };
                }
            }

        }
        return { applepay: applepay, samsungpay: samsungpay, googlepay: googlepay, yandexpay: yandexpay };
    },
    showPgButtons: function(rules) {
        if ( rules.applepay && window.applePaySeittings ) {
            if (window.egopay.inIframe()) {
                window.egopay.initApplePayIframe();
            } else {
                window.egopay.initApplePay();
            }
        } else {
            $('.apple-pay-button').hide();
        }
        if ( rules.googlepay ) {
            $('#googlepay').show();
            $('.google_pay_radio').show();
            window.egopay.initGooglePay();
        } else {
            $('#googlepay').hide();
        }
        if ( rules.samsungpay ) {
            $('.samsung_pay_radio').show();
            $('#samsungpay').show();
        } else {
            $('#samsungpay').hide();
        }
        if ( rules.yandexpay ) {
            $('.yandex_pay_radio').show();
            $('#yandexpay_button').show();
        }
    },
    init: function() {
        window.egopay.setLocale(window.locales[window.language] || window.locales.en);
        window.egopay.setElements(
            $('#paymentForm'),
            $('#loader'),
            $('#loader_fail')
        );
        var device = window.egopay.getDeviceInfo();
        var pgRules = window.egopay.detectPgRules(device);
        if (window.pm) {
            window.pm({
                target: window.parent,
                type: 'ShowPGButtons',
                data: pgRules
            });
        }
        window.egopay.showPgButtons(pgRules);
        // window.egopay.sendBrowserInfo();
        window.exception_card = [];
        // $.ajax({
        //     url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/get_exception_cards'),
        //     type: 'POST',
        //     dataType: 'json',
        //     contentType: 'application/json',
        //     success: function(data){
        //         window.exception_card = data;
        //     },
        // });
        $("#samsungpay").on("click", function() {
            window.egopay.samsungpayProcess(window.egopay.inIframe())
        });
        $("#sberpay_button").on("click", window.egopay.openSberPayModal);
        if (window.pm) {
            window.pm.bind('samsungProcess', function() {
                if (!window.samsungRefIDs || !window.samsungRefIDs.includes(arguments[0].refId)){
                    $(window).off('beforeunload');
                    var processUrl = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/samsungpay_process') +'?ref_id=' + arguments[0].refId;
                    window.location.replace(processUrl);
                }
            });
            window.pm.bind('samsungCancel', function() {
                window.egopay.showPaymentError();
            });
            window.pm.bind('pgScriptInit', function() {
                var topLocation = arguments[0].location;
                window.egopay.topLocation = topLocation.replace(/(pg|pg_action|ref_id)=[a-zA-Z0-9]+&/gi,"").replace(/&(pg|pg_action|ref_id)=[a-zA-Z0-9]+$/gi,"").replace(/\?(pg|pg_action|ref_id)=[a-zA-Z0-9]+$/gi,"");
            });
            window.pm.bind('ExtraPay', function() {
                var paymethod = arguments[0].paymethod;
                if (paymethod === 'apple_pay') {
                    console.log('try to pay apple pay');
                    window.egopay.initApplePayIframe();
                }
                if (paymethod === 'googlepay') {
                    console.log('try to pay google pay');
                    window.egopay.initGooglePay();
                }
                if (paymethod === 'samsungpay') {
                    console.log('try to pay samsung pay');
                    window.egopay.samsungpayProcess(false);
                }
            });
        }
        if ( window.show_gateway_error ) {
            window.egopay.showPaymentError();
        }
        if (window.yandexpaySettings) {
            window.egopay.initYandexpay();
        }
        // send status if user goes away from mobile version
        if  (window.egopay.isMobile.any()) {
            $(window).on('visibilitychange', function(){
                if (document.visibilityState == 'hidden') {
                        $.ajax({
                            url: window.location.toString().replace(/\/(card|test)\/index/gi, '/$1/client_status'),
                            type: 'POST',
                            data: JSON.stringify({'status': 'away'}),
                            dataType: 'json',
                            contentType: 'application/json',
                            traditional: false,
                            cache: false,
                            async: false
                        });
                }
            });

            $(window).blur(function(){
                $.ajax({
                        url: window.location.toString().replace(/\/(card|test)\/index/gi, '/$1/client_status'),
                        type: 'POST',
                        data: JSON.stringify({'status': 'away'}),
                        dataType: 'json',
                        contentType: 'application/json',
                        traditional: false,
                        cache: false,
                        async: false
                    });
            });

            $.ajax({
                url: "https://qr.nspk.ru/proxyapp/c2bmembers.json",
                type: 'GET',
                dataType: 'json',
                contentType: 'application/json',
                cache: false,
                success: function(data) {
                    window.egopay.c2bmemers = data.dictionary;
                }
            });
        }
        var fullCard = $('#cardccnumber').is(':visible') || $('#cc_part1').length === 0;
        function getCardNumber() {
            if (fullCard || $('#cc_part1:visible').length === 0) {
                var cardccnumber = $('#cardccnumber').val() || $('#cardtoken').val() || '';
                return cardccnumber.replace(/\s/g,'').replace(/X/g,'');
            } else {
                var cardNumber = $('#cc_part1').val() + $('#cc_part2').val() + $('#cc_part3').val() + $('#cc_part4').val();
                if ($('#cc_part5').length > 0) {
                    cardNumber += $('#cc_part5').val();
                }
                return cardNumber.split(' ')[0];
            }
        }

        function check_discount(){
            var card_number = getCardNumber();
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/index/gi, '/$1/get_discount'),
                type: 'POST',
                data: JSON.stringify({'card_number': card_number}),
                dataType: 'json',
                contentType: 'application/json',
                cache: false,
                success: function(data) {
                    if (data.delta_amount != 0){
                        var text_info = window.egopay.locale.discount_text + ': ';
                        text_info += data.delta_amount+ ' ' + data.currency;
                        $('.info').html(text_info);
                    }else{
                        $('.info').html('')
                    }
                    var loader_title_element = $('#loader .title');
                    if ($('.cost').length != 0){
                        var amount_element = $('.cost');
                    }else{
                        var amount_element = $('.order_desc__amount');
                    }
                    var font_size = amount_element.css('font-size');
                    if (amount_element.text().trim() != data.amount){
                        loader_title_element.html(data.loader_title);
                        amount_element.css({'font-size': "50px"});
                        amount_element.html(data.amount).animate({'font-size': font_size}, 500);
                    }
                }
            });
        }

        // $('#cc_part1').on('focusout',function(){
        //     check_discount();
        // });
        // $('#cc_part2').on('focusout',function(){
        //     check_discount();
        // });
        // $('#cc_part3').on('focusout',function(){
        //     check_discount();
        // });
        // $('#cc_part4').on('focusout',function(){
        //     check_discount();
        // });
        // $('#cc_part5').on('focusout',function(){
        //     check_discount();
        // });
        // $('#cardccnumber').on('focusout',function(){
        //     check_discount();
        // });
        window.egopay.setLocale(window.locales[window.language] || window.locales.en);
        window.egopay.setElements(
            $('#paymentForm'),
            $('#loader'),
            $('#loader_fail')
        );
        window.egopay.sayReady();
        /* ie6 fix */
        $('#go_purchase').on('click', function(e) {
            e.preventDefault();
            $('#paymentForm').submit();
        });

        //set sberPay number validation
        $.validator.addClassRules('sberpay__input', {
            required: true,
            phone: true,
        });

        $('#sberpay-payment__submit').on('click', function(e) {
            e.preventDefault();
            window.egopay.sberPayValidation();
        })

        $(window).on('beforeunload', window.egopay.confirmClose);
        $('a').on('click', function() {
            $(window).off('beforeunload');
        });

        // keepalive
        if (window.alive) {
            window.alive.onError = function() {
                window.egopay._fail('user/network', 'Keepalive period expired');
            };
            window.alive.init(window.location.toString().replace(/\/(card|test)\/index/gi, '/$1/alive'));
        }


        $('.binded_card input[type="radio"]').on("click", function() {
            var token = $(this).val();
            if (token !== "new") {
                var text = $(this).attr("data-text");
                var month = $(this).attr("data-month");
                var year = $(this).attr("data-year").substr(2);
                $(".selected_card").remove();
                var hiddenToken = '<input autocomplete="off" id="cardtoken" name="card.ccNumber" type="hidden" value="' + token + '" />';
                $(".front_side").append('<div class="selected_card">Карта   ' + text + hiddenToken + '</div>');
                $(".card_number").hide();
                $(".art").hide();
                $(".holder").hide();
                $("#cardccnumber").val(token);
                $("#expiredate").val(month + "/" + year);
                $("#cc_month").val(month);
                $("#cc_year").val(year);
                $("#cardholder").val("Unknown Holder");
                $(".save_card").hide();
            } else {
                $(".selected_card").remove();
                $("#cardccnumber").val("");
                $("#expiredate").val("");
                $("#cc_month").val("");
                $("#cc_year").val("");
                $("#cardholder").val("");
                $(".card_number").show();
                $(".art").show();
                $(".holder").show();
                $(".save_card").show();
            }
        });

        $(".binded_card-delete").on("click", function() {
            var token = $(this).attr("data-token");
            modalWindow(window.egopay.locale.askDelete, function(){
                deleteBindedCard(token);
            });
        });

        function deleteBindedCard(token) {
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, "/$1/unbind_card"),
                type: "POST",
                data: JSON.stringify({"token": token}),
                dataType: "json",
                contentType: "application/json",
                traditional: false,
                cache: false,
                error: function(jqXHR, textStatus, errorThrown) {
                    $(".binded").append(
                        '<div class="binded-error">' + window.egopay.locale.errUnbindCard + '</div>'
                    );
                    setTimeout(function() {
                        $('.binded-error').remove();
                    }, 3000);
                },
                success: function(data) {
                    if (data.error === 0){
                        $("#" + token).parent().parent().remove();
                    } else {
                        $(".binded").append(
                        '<div class="binded-error">' + window.egopay.locale.errUnbindCard + '</div>'
                    );
                    setTimeout(function() {
                        $('.binded-error').remove();
                    }, 3000);
                    }
                },
            });
        }

        function modalWindow(text, callback) {
            var modal = '';
            modal += '<div class="modal">';
            modal +=    '<div class="modal-shade"></div>';
            modal +=    '<div class="modal-container">';
            modal +=        '<div class="modal-text">' + text + '</div>';
            modal +=        '<div class="modal-buttons">';
            modal +=            '<button class="modal-button-no" id="button_no">' + window.egopay.locale.no + '</button>';
            modal +=            '<button id="button_yes">' + window.egopay.locale.yes + '</button>';
            modal +=        '</div>';
            modal +=    '</div>';
            modal += '</div>';
            $('body').append(modal);
            $('.modal-buttons button').on('click', function(){
                $('.modal').remove();
            });
            $('#button_yes').on('click', callback);
        }

        if (window.masterpassReq) {
            var masterpassReqJSON = atob(window.masterpassReq);
            var masterpassReq = JSON.parse(masterpassReqJSON);
            $("#masterpass").on('click', function(){
                masterpass.checkout(masterpassReq);
            });
        }
    },

    showElement: function(el) {
        if (window.egopay._elements[el]) {
            if (!window.egopay._elements[el].parent().is(':visible')) {
                window.egopay._elements[el].parent().show();
            }
            window.egopay._elements[el].show();
        }
    },

    sendBrowserInfo: function() {
        var browserInfo = {
          width: window.innerWidth || document.body.clientWidth,
          height: window.innerHeight || document.body.clientHeight
        };
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/browser_info'),
            type: 'POST',
            data: JSON.stringify(browserInfo),
            dataType: 'json',
            contentType: 'application/json'
        });
    },

    getBankName: function(cardnumber, callback) {
        var bin = cardnumber.slice(0,6);
        if (this.saved_bin !== bin) {
            this.saved_bin = bin;
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/binInfo'),
                type: 'POST',
                data: JSON.stringify({bin: bin}),
                dataType: 'json',
                contentType: 'application/json',
                success: function(data){
                    window.egopay.saved_bank = data.bank_name;
                    callback(data.bank_name);
                },
                error: function(data){
                    console.log('error get binInfo');
                },
            });
        } else if (this.saved_bank) {
            callback(window.egopay.saved_bank);
        }
    },

    initApplePay: function(){
        if (window.ApplePaySession) {
            var promise = ApplePaySession.canMakePaymentsWithActiveCard(window.applePaySeittings.merchantIdentifier);
            var status;
            promise.then(function (canMakePayments) {
                if (canMakePayments) {
                    $(".apple-pay-button").show();
                    $(".apple_pay_radio").show();
                }
                $(".apple-pay-button").on("click", function() {
                    $('#errorMessage').remove();
                    var session = new ApplePaySession(4, window.applePaySeittings.request);
                    session.onvalidatemerchant = function (event) {
                        var promise = window.egopay.performValidation(event.validationURL, location.origin);
                        promise.then(function (merchantSession) {
                            session.completeMerchantValidation(merchantSession);
                        });
                    }
                    session.onshippingcontactselected = function(event) {
                        var status = ApplePaySession.STATUS_SUCCESS;
                        var newShippingMethods = {};
                        var newTotal = {};
                        var newLineItems =[];
                        session.completeShippingContactSelection(status, newShippingMethods, newTotal, newLineItems );
                    }

                    session.onshippingmethodselected = function(event) {
                        var status = ApplePaySession.STATUS_SUCCESS;
                        var newTotal = {};
                        var newLineItems =[];

                        session.completeShippingMethodSelection(status, newTotal, newLineItems );


                    }

                    session.onpaymentmethodselected = function(event) {
                        var newTotal = {
                            'amount': window.applePaySeittings.request.total.amount,
                            'label': window.applePaySeittings.description
                        };
                        var newLineItems =[];

                        session.completePaymentMethodSelection( newTotal, newLineItems );


                    }
                    session.onpaymentauthorized = function (event) {
                        var resultUrl = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/result')
                        var applePayData = {};
                        applePayData.token = event.payment.token;
                        var promise = window.egopay.processApplePay(applePayData);
                        promise.then(function (success) {
                            if (success){
                                var resultPromise = window.egopay.ApplePayResult();
                                resultPromise.then(function (result){
                                    if (result){
                                        status = ApplePaySession.STATUS_SUCCESS;
                                    } else {
                                        status = ApplePaySession.STATUS_FAILURE;
                                    }
                                    session.completePayment(status);
                                    $(window).off('beforeunload');
                                    window.location.replace(resultUrl);
                                });
                            } else {
                                status = ApplePaySession.STATUS_FAILURE;
                                session.completePayment(status);
                            }
                        });
                    }
                    session.oncancel = function(event) {
                        $(window).off('beforeunload');
                        window.location.reload()
                    }
                    session.begin();

                });
            });
        }
    },

    initApplePayIframe: function() {
        if (window.pm) {
            window.pm.bind('canMakeApplePayments', function() {
                $(".apple-pay-button").show();
            });
            $(".apple-pay-button").on("click", function() {
                window.pm({
                    target: window.parent,
                    type: 'applepayButtonPressed',
                    data: {
                        request: window.applePaySeittings.request,
                        amount: window.applePaySeittings.request.total.amount,
                        label: window.applePaySeittings.description
                    }
                });
            });
            window.pm.bind('appleMerchantValidate', function() {
                var promise = window.egopay.performValidation(arguments[0].validationURL, arguments[0].origin);
                promise.then(function (merchantSession) {
                    window.pm({
                        target: window.parent,
                        type: 'merchantSession',
                        data: {merchantSession: merchantSession}
                    });
                });
            });
            window.pm.bind('applepayProcess', function() {
                var applePayData = {};
                applePayData.token = arguments[0];
                var promise = window.egopay.processApplePay(applePayData);
                promise.then(function (success) {
                    if (success){
                        var resultPromise = window.egopay.ApplePayResult();
                        resultPromise.then(function (result){
                            window.pm({
                                target: window.parent,
                                type: 'applepayResult',
                                data: {data: !!result}
                            });
                        });
                    } else {
                        window.pm({
                            target: window.parent,
                            type: 'applepayResult',
                            data: {data: false}
                        });
                    }
                });
            });
            window.pm.bind('applepayCancel', function() {
                $(window).off('beforeunload');
                window.location.reload();
            });
            window.pm.bind('applepayFinished', function() {
                $(window).off('beforeunload');
                var resultUrl = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/result')
                window.location.replace(resultUrl);
            });
        }
    },

    performValidation: function(url, origin){
        return new Promise(function(resolve, reject) {
            var validationData = {
                url: url,
                origin: origin
            };
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/applepay_validate'),
                type: 'POST',
                data: JSON.stringify(validationData),
                dataType: 'json',
                contentType: 'application/json',
                traditional: false,
                cache: false,
                error: reject,
                success: function(data) {
                    if (data === "Error"){
                        reject;
                    }else{
                        resolve(data);
                    }
                }
            });
        });
    },

    processApplePay: function (data){
        return new Promise(function(resolve, reject) {
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/applepay_process'),
                type: 'POST',
                data: JSON.stringify(data),
                dataType: 'json',
                contentType: 'application/json',
                traditional: false,
                cache: false,
                error: reject,
                success: function(data) {
                    if (data.result === "system/ok"){
                        resolve(true);
                    }else{
                        resolve(false);
                    }
                }
            });
        });
    },

    ApplePayResult: function (){
        return new Promise(function(resolve, reject) {
            $.ajax({
                url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/applepay_result'),
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                traditional: false,
                cache: false,
                error: reject,
                success: function(data) {
                    if (data.result === "repeat"){
                        setTimeout(
                          function() {
                              var promise = window.egopay.ApplePayResult();
                              promise.then(function (success) {
                                  resolve(success);
                              });
                          },
                          3000
                        );

                    }else if (data.result === "success"){
                        resolve(true);
                    } else {
                        resolve(false);
                    }
                }
            });
        });
    },
    isMobile: {
        Samsung: function() {
            return navigator.userAgent.match(/SAMSUNG|SGH-[I|N|T]|GT-[I|P|N]|SM-[N|P|T|Z|G]|SHV-E|SCH-[I|J|R|S]|SPH-L|SM-[A]/i);
        },
        Android: function() {
            return navigator.userAgent.match(/Android/i);
        },
        BlackBerry: function() {
            return navigator.userAgent.match(/BlackBerry/i);
        },
        iOS: function() {
            return navigator.userAgent.match(/iPhone|iPad|iPod/i);
        },
        Opera: function() {
            return navigator.userAgent.match(/Opera Mini/i);
        },
        Windows: function() {
            return navigator.userAgent.match(/IEMobile/i);
        },
        any: function() {
            return (this.Android() || this.BlackBerry() || this.iOS() || this.Opera() || this.Windows());
        }
    },
    initYandexpay: function (){
        var YaPay = window.YaPay;

        // Сформировать данные платежа.
        var allowedAuthMethods = [];
        for (var i in window.yandexpaySettings.paymentMethods.allowedAuthMethods){
            allowedAuthMethods.push(YaPay.AllowedAuthMethod[window.yandexpaySettings.paymentMethods.allowedAuthMethods[i]]);
        }
        var allowedCardNetworks = [];
        for (var i in window.yandexpaySettings.paymentMethods.allowedCardNetworks){
            allowedCardNetworks.push(YaPay.AllowedCardNetwork[window.yandexpaySettings.paymentMethods.allowedCardNetworks[i]]);
        }
        var paymentData = {
            env: YaPay.PaymentEnv[window.yandexpaySettings.env],
            version: window.yandexpaySettings.version,
            countryCode: window.yandexpaySettings.countryCode,
            currencyCode: window.yandexpaySettings.currencyCode,
            merchant: {
              id: window.yandexpaySettings.merchant.id,
              name: window.yandexpaySettings.merchant.name,
              url: window.yandexpaySettings.merchant.url
            },
            order: {
              id: window.yandexpaySettings.order.id,
              total: { amount: window.yandexpaySettings.order.amount },
              items: window.yandexpaySettings.order.items
            },
            paymentMethods: [
              {
                type: YaPay.PaymentMethodType[window.yandexpaySettings.paymentMethods.type],
                gateway: window.yandexpaySettings.paymentMethods.gateway,
                gatewayMerchantId: window.yandexpaySettings.paymentMethods.gatewayMerchantId,
                allowedAuthMethods: allowedAuthMethods,
                allowedCardNetworks: allowedCardNetworks
              }
            ],
        };
        // Создать платеж.
        YaPay.createPayment(paymentData)
        .then(function (payment) {
          // Создать экземпляр кнопки.
          var container = document.querySelector('#yandexpay_button');
          var btnTheme;
          if (window.yandexpaySettings.button_theme) {
            btnTheme = YaPay.ButtonTheme[window.yandexpaySettings.button_theme]
          } else {
            btnTheme = YaPay.ButtonTheme.Black;
          }
          var button = payment.createButton({
            type: YaPay.ButtonType.Pay,
            theme: btnTheme,
            width: YaPay.ButtonWidth.Auto,
          });

          // Смонтировать кнопку в DOM.
          button.mount(container);

          // Подписаться на событие click.
          button.on(YaPay.ButtonEventType.Click, function onPaymentButtonClick() {
            // Запустить оплату после клика на кнопку.
            payment.checkout();
          });

          // Подписаться на событие error.
          payment.on(YaPay.PaymentEventType.Error, function onPaymentError(event) {
            // Вывести информацию о недоступности оплаты в данный момент
            // и предложить пользователю другой способ оплаты.
            console.log("failed yandex pay");
            console.log(event);
            window.egopay.showPaymentError();
            // Закрыть форму Yandex.Pay.
            payment.complete(YaPay.CompleteReason.Error);
          });

          // Подписаться на событие abort.
          // Это когда пользователь закрыл форму Yandex Pay.
          payment.on(YaPay.PaymentEventType.Abort, function onPaymentAbort(event) {
            console.log("user abort yandex pay");
          });

          // Подписаться на событие process.
          payment.on(YaPay.PaymentEventType.Process, function onPaymentProcess(event) {
            // Получить платежный токен.
            console.log('Payment token — ' + event.token);
            var processData = {token: event.token};
            window.egopay.processYandexPay(processData);
            // Закрыть форму Yandex Pay.
            payment.complete(YaPay.CompleteReason.Success);
          });
        })
        .catch(function (err) {
          // Платеж не создан.
          console.log("yandex pay error");
          console.log(err);
        });
    },
    initGooglePay: function (){
        var baseRequest = {
            apiVersion: 2,
            apiVersionMinor: 0
        };
        var allowedCardNetworks = window.googlePaySettings.allowedCardNetworks;
        var allowedCardAuthMethods = window.googlePaySettings.allowedCardAuthMethods;
        var tokenizationSpecification = window.googlePaySettings.tokenizationSpecification;

        var baseCardPaymentMethod = {
            type: 'CARD',
            parameters: {
                allowedAuthMethods: allowedCardAuthMethods,
                allowedCardNetworks: allowedCardNetworks,
                assuranceDetailsRequired: true
            }
        };
        var cardPaymentMethod = $.extend(
            {},
            baseCardPaymentMethod,
            {tokenizationSpecification: tokenizationSpecification}
        );

        function getGoogleIsReadyToPayRequest() {
            return $.extend(
                {},
                baseRequest,
                {
                    allowedPaymentMethods: [baseCardPaymentMethod]
                }
          ) ;
        }

        function getGooglePaymentDataRequest() {
            var paymentDataRequest = $.extend({}, baseRequest);
            paymentDataRequest.allowedPaymentMethods = [cardPaymentMethod];
            paymentDataRequest.transactionInfo = getGoogleTransactionInfo();
            paymentDataRequest.merchantInfo = {};
            paymentDataRequest.merchantInfo.merchantId = window.googlePaySettings.merchant.id;
            paymentDataRequest.merchantInfo.merchantName = window.googlePaySettings.merchant.name;
            paymentDataRequest.merchantInfo.merchantOrigin = window.googlePaySettings.merchant.origin;
            return paymentDataRequest;
        }

        function getGoogleTransactionInfo() {
            return {
                countryCode: window.googlePaySettings.info.countryCode,
                currencyCode: window.googlePaySettings.info.currencyCode,
                totalPriceStatus: 'FINAL',
                totalPrice: window.googlePaySettings.info.totalPrice,
            };
        }

        function addGooglePayButton() {
            var button = paymentsClient.createButton({
                onClick: onGooglePaymentButtonClicked,
                buttonType: 'plain',
                buttonSizeMode: 'fill',
                buttonColor: window.googlePayColor || 'default',
            });
            document.getElementById('googlepay').appendChild(button);
        }

        function onGooglePaymentButtonClicked() {
            $('#errorMessage').remove();
            var paymentDataRequest = getGooglePaymentDataRequest();
            paymentsClient.loadPaymentData(paymentDataRequest)
                .then(function(paymentData) {
                    // handle the response
                    window.egopay.processGooglePay(paymentData);
                })
                .catch(function(err) {
                    // show error in developer console for debugging
                    // console.error(err);
                });
        }

        var paymentsClient = new google.payments.api.PaymentsClient({environment: window.googlePaySettings.environment});

        paymentsClient.isReadyToPay(getGoogleIsReadyToPayRequest())
            .then(function(response) {
                if (response.result) {
                    addGooglePayButton();
                }
            })
            .catch(function(err) {
                // console.error(err);
            });
    },
    processGooglePay: function (data){
        this._show();
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/googlepay_process'),
            type: 'POST',
            data: JSON.stringify(data),
            dataType: 'json',
            contentType: 'application/json',
            traditional: false,
            cache: false,
            success: function(data) {
                if (data.result === "system/ok"){
                    var secureUrl = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/secure')
                    $(window).off('beforeunload');
                    window.location.replace(secureUrl);
                } else {
                    window.egopay.showForm();
                    window.egopay.showPaymentError();
                    window.location.reload();
                }
            }
        });
    },
    processYandexPay: function (data){
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/yandexpay_process'),
            type: 'POST',
            data: JSON.stringify(data),
            dataType: 'json',
            contentType: 'application/json',
            traditional: false,
            cache: false,
            success: function(data) {
                if (data.result === "system/ok"){
                    var secureUrl = window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/secure')
                    $(window).off('beforeunload');
                    window.location.replace(secureUrl);
                } else {
                    window.egopay.showForm();
                    window.egopay.showPaymentError();
                }
            }
        });
    },
    sberPayValidation: function() {
        var isValid = $('.sberpay__input').valid();
        if(!isValid) return;
        var sberPayInputValue = $('.sberpay__input').intlTelInput("getNumber").slice(1);
        var requestData = {
            "phone": Number(sberPayInputValue)
        }
        window.egopay.processSberPay(requestData);
    },
    processSberPay: function(data) {
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/cbp/register'),
            type: 'POST',
            data: JSON.stringify(data),
            dataType: 'json',
            contentType: 'application/json',
            traditional: false,
            cache: false,
            error: function() {
                $('.sberPayMessage').remove();
                window.egopay.sberPayRequestErrorMessage(window.egopay.locale['sberPayMessageUnavailable']);
            },
            success: function(data) {
                $('.sberPayMessage').remove();
                if(data.duplicate) {
                    window.egopay.sberPayRequestDublicateMessage(window.egopay.locale['sberPayMessageRegistered']);
                } else if(data.error === 0) {
                    window.egopay.sberPayRequestSuccessMessage(window.egopay.locale['sberPayRequestSuccessMessage']);
                    window.egopay.getSberPayStatus();
                } else if(data.error === 300) {
                    window.egopay.sberPayRequestErrorMessage(window.egopay.locale['sberPayMessageUnavailable']);
                }
            }
        });
    },
    getSberPayStatus: function() {
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/cbp/status'),
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            error: function() {
                window.egopay.getSberPayStatusWithTimeout();
            },
            success: function(data) {
                if(data.status !== 'failed' && data.status !== 'success') window.egopay.getSberPayStatusWithTimeout();

                if(data.status === 'success' || data.status === 'failed') {
                    window.egopay.getOrderStatusWithTimeout();
                }
            }
        });
    },
    getSberPayStatusWithTimeout: function() {
        setTimeout(function() {
            window.egopay.getSberPayStatus();
        }, 1000)
    },
    sberPayRequestErrorMessage: function(message) {
        $(".sberpay-payment__tip").text(message).addClass('sberPayMessageUnavailable');
    },
    sberPayRequestDublicateMessage: function(message) {
        $(".sberpay-payment__tip").text(message).addClass('sberPayMessageRegistered');
    },
    sberPayRequestSuccessMessage: function(message) {
        $(".sberpay-payment__tip").text(message).addClass('sberPayMessageSuccess');
    },
    getOrderStatus: function() {
        $.ajax({
            url: window.location.toString().replace(/\/(card|test)\/(card|index)/gi, '/$1/order_status'),
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            error: function() {
                window.egopay.getOrderStatusWithTimeout();
            },
            success: function(data) {


                if(data.url) {
                    $(window).off('beforeunload');
                    var resultUrl = window.location.origin + data.url;
                    window.location.replace(resultUrl);
                } else {
                    window.egopay.getOrderStatusWithTimeout();
                }
            }
        });
    },
    getOrderStatusWithTimeout: function() {
        setTimeout(function() {
            window.egopay.getOrderStatus();
        }, 1000)
    },
    openSberPayModal: function() {
        $("#sberpay_button").off();
        var modal = '';
        modal += '<div id="sberPayModal">';
            modal += '<div class="sberpay_modal-background">';
            modal += '<div class="sberpay_modal">';
                modal += '<button role="button" type="button" class="sberpay_btn-close"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g fill="none" fill-rule="evenodd"><path d="M1 0h24v24H1z"/><path fill="#000" fill-rule="nonzero" d="M13.003 12.717l7.21 7.21.714-.714-7.21-7.21L21 4.72 20.28 4l-7.283 7.283-7.21-7.21-.714.714 7.21 7.21L5 19.28l.72.72 7.283-7.283z"/></g></svg></button>';
                modal += '<div class="payment-card__sberpay">';
                    modal += '<div class="sberpay-wrapp">';
                        modal += '<div class="sberpay-wrapp-left">';
                            modal += '<span class="payment-card-sberpay__title">Sberpay</span>'
                            modal += '<p class="payment-card-sberpay__text">' + window.egopay.locale['sberpay_1'] + window.egopay.locale['sberpay_2'] + '</p>';
                        modal += '</div>';
                    modal += '</div>';
                    modal += '<div class="payment-card-sberpay-bottom">';
                        modal += '<a target="_blank" href="https://www.sberbank.ru/ru/person/payments/sberpay" class="payment-card-sberpay__link howToPayWithSberpay">' + window.egopay.locale['howToPayWithSberpay'] + '</a>';
                        modal += '<label class="sberpay-label">';
                            modal += '<span class="sberpay__span mobilePhone">' + window.egopay.locale['mobilePhone'] + '</span>';
                            modal += '<input type="tel" class="sberpay__input" name="phone" value="" />';
                        modal += '</label>';
                    modal += '</div>';
                    modal += '<div class="sberpay-payment-submit">';
                        modal += '<p class="sberpay-payment__text">'+ window.egopay.locale['Sbep pay text'] + '</p>';
                        modal += '<div id="sberpay-payment__submit" class="sberpay_button">';
                            modal += '<span class="sberpay_logo"></span>';
                        modal += '</div>';
                        modal += '<div class="sberpay-payment__tip">' + window.egopay.locale['Sber tip'] + '</div>';
                        modal += '<div class="sberpay-payment__lic">' + window.egopay.locale['Sber licence'] + '</div>';
                    modal += '</div>';
                modal += '</div>';
            modal += '</div>';
        modal += '</div>';
        $("#paymentForm").append(modal);
        $('body').addClass('overflow-hidden');
        $(".sberpay_btn-close").on('click', function() {
            $("#sberPayModal").remove();
            $('body').removeClass('overflow-hidden');
            $("#sberpay_button").on('click', window.egopay.openSberPayModal);
        })
        $('.sberpay__input').intlTelInput({
            initialCountry: "ru",
            formatOnDisplay: true,
            autoPlaceholder: "aggressive",
            placeholderNumberType: "MOBILE",
            preferredCountries: ["ru"],
            separateDialCode: true,
            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.14/js/utils.js",
        })
        function setDefaultPhonePlaceholder() {
            $('.sberpay__input').attr('placeholder', "");
        }
        setTimeout(setDefaultPhonePlaceholder, 1000);
        $('.sberpay__input').inputmask("999 999-99-99");
        $('.sberpay__input').on('countrychange', function(e){
            $(this).val("");
            var currentMask = $(this).attr('placeholder').replace(/[0-9+]/ig,'9');
            $(this).attr('placeholder', "");
            $('.sberpay__input').inputmask(currentMask);
        });

        if(window.language === 'ru') {
            $('.payment-card-sberpay__link').attr('href', 'https://www.sberbank.ru/ru/person/payments/sberpay')
        } else {
            $('.payment-card-sberpay__link').attr('href', 'https://www.sberbank.ru/en/individualclients')
        }

        $('#sberpay-payment__submit').on('click', function(e) {
            e.preventDefault();
            window.egopay.sberPayValidation();
        })
    }
};
