"use strict";
window.alfabank = {
  init: function () {
    var map = {
      й: "q",
      ц: "w",
      у: "e",
      к: "r",
      е: "t",
      н: "y",
      г: "u",
      ш: "i",
      щ: "o",
      з: "p",
      х: "[",
      ъ: "]",
      ф: "a",
      ы: "s",
      в: "d",
      а: "f",
      п: "g",
      р: "h",
      о: "j",
      л: "k",
      д: "l",
      ж: ";",
      э: "'",
      я: "z",
      ч: "x",
      с: "c",
      м: "v",
      и: "b",
      т: "n",
      ь: "m",
      б: ",",
      ю: ".",
    };

    $("#cardccnumber").closest(".input").addClass("input_focused in_focus");
    $("#cardccnumber").focus();

    $("#cardholder").on("keypress", function (e) {
      var charStr = e.key;
      if (/\d/.test(charStr)) {
        return false;
      }
      var char;
      if (map[charStr]) {
        char = map[charStr];
      } else {
        char = charStr;
      }
      var val = $("#cardholder").val() + char;
      $("#cardholder").val(val);
      return false;
    })

    $(".elem_input").on("focusin", function () {
      $(this).closest(".input").addClass("input_focused in_focus");
    })

    $(".elem_input").on("focusout", function () {
      if (!this.value.trim()) {
        $(this).closest(".input").removeClass("input_focused");
      }
      $(this).closest(".input").removeClass("in_focus");
    })

    $("#cardccnumber").on("keyup change paste", function () {
      // var cardnumber = $("#cardccnumber").val().replace(/\D/g, "");
      // if (cardnumber.length >= 6) {
      //   window.egopay.getBankName(cardnumber, setBrandCard);
      // } else {
      //   setBrandCard("");
      // }
      // var cardType = window.egopay.getCardType(cardnumber).type;
      // if ( cardnumber.length > 11 && cardType === 'visa' ) {
      //     $("#visacredit").show();
      // } else {
      //     $("#visacredit").hide();
      // }
      // if ( cardnumber.length > 5 && cardType === 'mastercard' ) {
      //     $("#mccredit").show();
      // } else {
      //     $("#mccredit").hide();
      // }
    })

    function setBrandCard(bank_name) {
      var cardnumber = $("#cardccnumber").val().replace(/\D/g, "");
      var cardInfo = new CardInfo(cardnumber, bank_name);

      if (cardInfo.bankLogo) {
        $(".card__front").css("background", cardInfo.backgroundGradient);
        $(".card__front .input__top, .card__front .elem_input").css("color", cardInfo.textColor);
        if (cardInfo.backgroundLightness === "dark") {
          $(".card__front .input__box").addClass("border_light");
        } else {
          $(".card__front .input__box").removeClass("border_light");
        }
      } else {
        $(".card__front").removeAttr("style");
        $(".card__front .input__top, .card__front .elem_input").removeAttr("style");
        $(".card__front .input__box").removeClass("border_light");
      }

      if (cardInfo.brandName === "American Express") {
        $("#cardcccode").attr("maxlength", 4);
      } else {
        $("#cardcccode").attr("maxlength", 3);
      }

      var currentCardType = window.egopay.getCardType($('#cardccnumber').val().replace(/\s/g,'')).type;

      var logoPaths = {
        "visa": 'visa-colored.svg',
        "dinersclub": 'diners-club-colored.png',
        "amex": 'american-express-colored.svg',
        "mir": 'mir-alfabank-colored.png',
        "mastercard": 'master-card-colored.svg',
        "master": 'master-card-colored.svg',
        "jcb": 'jcb-colored.svg',
        "cup": 'unionpay-colored.svg',
        "maestro": 'maestro-colored.png',
      };

      if(currentCardType && logoPaths.hasOwnProperty(currentCardType)) {
        var path = '../../../media/img/brands-logos/';
        var logo = path + logoPaths[currentCardType];
        if(logo.includes('.png')) $("#brand-logo").addClass(currentCardType)
        $("#brand-logo").css('background-image', `url(${logo})`).show();
      } else {
        $("#brand-logo").removeClass('visa dinersclub amex mir mastercard master jcb cup maestro').hide();
      }
    }

    $("#expiredate").on("keyup", (e) => {
      if ($("#expiredate").val().length > 4) {
        $(this).closest(".input").addClass("input_focused");
        $(this).closest(".input").addClass("in_focus");
        $("#expiredate").blur();

        $("#cardcccode").closest(".input").addClass("input_focused");
        $("#cardcccode").closest(".input").addClass("in_focus");
        $("#cardcccode").focus();
      }
    })

    var maskOptions = {
      placeholder: "",
      clearMaskOnLostFocus: true,
      showMaskOnHover: false,
      showMaskOnFocus: false,
      greedy: false,
    }
    $('#cardccnumber').inputmask('9{4} 9{4} 9{4} 9{4}[ 9{3}]', maskOptions);
    $('#cardccnumber').on('keyup', function() {
      $('#cardccnumber').val($('#cardccnumber').val().trim())
    });

    $("#expiredate").inputmask("9{2}[/9{2}]", maskOptions);
    $("#cardcccode").payment("formatCardCVC");

    $(".notification__closer").on("click", function () {
      $(".notification").removeClass("notification_visible").hide();
    })

    $("#cardcccode").on("input", (e) => {
      var maxlength = $('#cardcccode').attr('maxlength');
      if (
        ($("#cardcccode").val().length == 3 && maxlength == 3) ||
        ($("#cardcccode").val().length == 4 && maxlength == 4))
      {
        $('.payment__payment-buttons #go_purchase').focus()
      }
    })
  },
}

if (window.egopay) {
  $.validator.setDefaults({
    onfocusout: false,
  })
  window.egopay.expired = function () {
    $(".notification").show().addClass("notification_visible");
    window.egopay.showForm();
  }
}
