"use strict";
$(document).ready(function () {
  if (window.innerWidth < 1023) {
    $('.logo').addClass('shop_logo_mobile');
    $('#brand-logo').addClass('brand-logo_mobile');
  }

  var saved_lang = localStorage.getItem('language');
  $('.select_language select').val(window.language || saved_lang);
  $('.select-button__text-span').text($('.select_language select option:selected').text());
  $('.select-selected').text($('.select_language select option:selected').text());

  var x, i, j, l, ll, selElmnt, a, b, c;
  /* Look for any elements with the class "select_language": */
  x = document.getElementsByClassName("select_language");
  l = x.length;
  for (i = 0; i < l; i++) {
    selElmnt = x[i].getElementsByTagName("select")[0];
    ll = selElmnt.length;
    /* For each element, create a new DIV that will act as the selected item: */
    a = document.createElement("DIV");
    a.setAttribute("class", "select-selected");
    a.innerHTML = selElmnt.options[selElmnt.selectedIndex].innerHTML;
    x[i].appendChild(a);
    /* For each element, create a new DIV that will contain the option list: */
    b = document.createElement("DIV");
    b.setAttribute("class", "select-items select-hide");
    for (j = 1; j < ll; j++) {
      /* For each option in the original select element,
          create a new DIV that will act as an option item: */
      c = document.createElement("DIV");
      c.innerHTML = selElmnt.options[j].innerHTML;
      if ($('.select_language select').val() === selElmnt.options[j].value) {
        c.setAttribute("class", "same-as-selected");
      }
      c.addEventListener("click", function () {
        /* When an item is clicked, update the original select box,
            and the selected item: */
        var y, i, k, s, h, sl, yl;
        s = this.parentNode.parentNode.getElementsByTagName("select")[0];
        sl = s.length;
        h = this.parentNode.previousSibling;
        for (i = 0; i < sl; i++) {
          if (s.options[i].innerHTML == this.innerHTML) {
            s.selectedIndex = i;
            h.innerHTML = this.innerHTML;
            y = this.parentNode.getElementsByClassName("same-as-selected");
            yl = y.length;
            for (k = 0; k < yl; k++) {
              y[k].removeAttribute("class");
            }
            this.setAttribute("class", "same-as-selected");
            changeLanguage($('.select_language select').val());
            break;
          }
        }
        h.click();
      });
      b.appendChild(c);
    }
    x[i].appendChild(b);
    var selectButton = document.querySelector('.select-button');
    selectButton.addEventListener("click", function (e) {
      /* When the select box is clicked, close any other select boxes,
          and open/close the current select box: */
      e.stopPropagation();
      var element = document.querySelector('.select-selected');
      var items = document.querySelector('.select-items')
      closeAllSelect(element);
      items.classList.toggle("select-hide");
      selectButton.querySelector('.icon').classList.toggle("icon_name_arrow-up");
    });
  }

  $('.select_language select').on('click', (e) => {
    var element = document.querySelector('.select-selected');
    e.stopPropagation();
    closeAllSelect(element);
    element.nextSibling.classList.toggle("select-hide");
    element.classList.toggle("select-arrow-active");
  })

  $('.select_language select').on("change", function (e) {
    changeLanguage($('.select_language select').val());
    $('.select-button__text-span').text($('.select_language select option:selected').text());
    $('.select-selected').text($('.select_language select option:selected').text());
  });

  function closeAllSelect(elmnt) {
    /* A function that will close all select boxes in the document,
          except the current select box: */
    var arrNo = [];
    var selects = document.getElementsByClassName("select-items");
    var buttons = document.getElementsByClassName("select-selected");
    var selectButton = document.querySelector('.select-button');
    for (var button = 0; button < buttons.length; button++) {
      if (elmnt == buttons[button]) {
        arrNo.push(buttons);
      } else {
        buttons[button].classList.remove("select-arrow-active");
        selectButton.querySelector('.icon').classList.remove("icon_name_arrow-up");
      }
    }
    for (var select = 0; select < select.length; select++) {
      if (arrNo.indexOf(select)) {
        selects[select].classList.add("select-hide");
      }
    }
    $('.select-button__text-span').text($('.select_language select option:selected').text());
  }

  /* If the user clicks anywhere outside the select box,
          then close all select boxes: */
  document.addEventListener("click", function (e) {
    var selects = document.getElementsByClassName("select-items");
    closeAllSelect();
    if (!selects[0].classList.contains('select-hide')) {
      selects[0].classList.add('select-hide');
    }
  });

  var pdfURL = $('.result_check').attr('href');

  function changeLanguage(lang) {
    var selectedLang = lang;
    $('.logo').toggleClass('logo_en', selectedLang !== 'ru');
    window.language = selectedLang; 
    window.egopay.setLocale(window.locales[selectedLang] || window.locales.en);
    window.egopay.locale = jQuery.extend(window.egopay.locale, customLocales);
    var texts = localization[selectedLang];
    for (var id in texts) {
      if (!$('.' + id)) continue;
      $('.' + id).text(texts[id]);
    }
    if (selectedLang !== 'ru') {
      $('.order_desc-tip-text').css('font-size', 0);
      $('.order_desc-tip-text a').text(localization[selectedLang]['order_desc-tip-link']);

      if (selectedLang === 'zh') {
        $('.button_size_xl').addClass('zh-toggle');
        $('.button_size_xl.toggle').removeClass('toggle');
        $('.button_size_xl.fr-toggle').removeClass('fr-toggle');
        $('.button_size_xl.kz-toggle').removeClass('kz-toggle');
        $('.select-selected').addClass('zh-toggle');
        $('.finish__info-button-block input').addClass('zh-toggle');
      } else if (selectedLang === 'fr') {
        $('.button_size_xl').addClass('fr-toggle');
        $('.button_size_xl.toggle').removeClass('toggle');
        $('.button_size_xl.zh-toggle').removeClass('zh-toggle');
        $('.button_size_xl.kz-toggle').removeClass('kz-toggle');
        $('.select-selected.zh-toggle').removeClass('zh-toggle');
        $('.finish__info-button-block input.zh-toggle').removeClass('zh-toggle');
      } else if (selectedLang === 'kk') {
        $('.button_size_xl').addClass('kz-toggle');
        $('.button_size_xl.toggle').removeClass('toggle');
        $('.button_size_xl.fr-toggle').removeClass('fr-toggle');
        $('.button_size_xl.zh-toggle').removeClass('zh-toggle');
        $('.select-selected.zh-toggle').removeClass('zh-toggle');
        $('.finish__info-button-block input.zh-toggle').removeClass('zh-toggle');
      } else {
        $('.button_size_xl').addClass('toggle');
        $('.button_size_xl.zh-toggle').removeClass('zh-toggle');
        $('.button_size_xl.fr-toggle').removeClass('fr-toggle');
        $('.button_size_xl.kz-toggle').removeClass('kz-toggle');
        $('.select-selected.zh-toggle').removeClass('zh-toggle');
        $('.finish__info-button-block input.zh-toggle').removeClass('zh-toggle');
      }

    } else {
      $('.order_desc-tip-text').css('font-size', '16px');
      $('.order_desc-tip-text a').text('подробнее');
      $('.button_size_xl.toggle').removeClass('toggle');
      $('.button_size_xl.zh-toggle').removeClass('zh-toggle');
      $('.button_size_xl.fr-toggle').removeClass('fr-toggle');
    }
    if ($('.finish__info-button-block input')) {
      $('.finish__info-button-block input').text(localization[selectedLang].go_accept);
      $('.finish__info-button-block input').val(localization[selectedLang].go_accept);
    }
    if($('.reason') && window.decline_reason) {
      $('.reason').text(getReason(window.decline_reason));
    }
    $('#payment_timer-value').html(toDDHHMMSS(window.timestamp_order_time - parseInt(new Date().getTime()/1000)));
    var errors = localizationErrors[selectedLang];
    for (var error in errors) {
      $('label[for=' + error + ']').text(errors[error])
    }
    $('.result_check').attr('href', pdfURL + '?lang=' + selectedLang)
    localStorage.setItem('language', selectedLang);
  }

  function clearStorage() {
    delete localStorage['language'];
  }

  $('#loader_error .button').on('click', clearStorage);
  $('#loader_success .button').on('click', clearStorage);
  $('#issue_timeout .button').on('click', clearStorage);

  function toDDHHMMSS(str) {
    var sec_num = parseInt(str, 10),
      days = Math.floor(sec_num / 3600 / 24),
      hours = Math.floor((sec_num - (days * 24 * 3600)) / 3600),
      minutes = Math.floor((sec_num - (days * 24 * 3600) - (hours * 3600)) / 60),
      seconds = sec_num - (days * 24 * 3600) - (hours * 3600) - (minutes * 60),
      time = '';

    time = ('0' + hours).slice(-2) + ':' + ('0' + minutes).slice(-2) + ':' + ('0' + seconds).slice(-2);
    if (days) {
      var lang = window.language;
      time = days + `<span id="days">${localization[lang]['days']}</span>` + time;
    }
    return time;
  }

  var localization = {
    'ru': {
      'order_number-text': 'Номер заказа',
      'order_comment-text': 'Описание платежа',
      'order_desc-tip-link': 'подробнее',
      'payment_timer-text': 'До окончания сессии осталось',
      'cardnumber_label': 'Номер карты',
      'result_cardnumber_label': 'Номер карты',
      'cardholder_label': 'Имя владельца',
      'date_label': 'ММ/ГГ',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Последние 3 цифры на обороте',
      'contact_info-email': 'Нам понадобится ваш email, чтобы мы могли отправить на него уведомление о платеже',
      'contact_info-phone': 'Нам понадобится ваш № телефона, чтобы мы могли отправить на него уведомление о платеже',
      'go_purchase': 'Оплатить',
      'go_credit': 'Оплатить в кредит',
      'payment_denied': 'Оплата отклонена',
      'payment_success': 'Платёж успешно завершён',
      'payment_issue': 'Оплата отклонена',
      'result_company': 'Организация',
      'result_date': 'Дата оплаты',
      'result_number': 'Номер заказа',
      'result_comment': 'Причина отклонения',
      'result_amount': 'Сумма платежа',
      'result_extra': 'Комиссия за платеж',
      'result_cancel': 'Вернуться в магазин',
      'try_again': 'Попробовать снова',
      'go_accept': 'Вернуться в магазин',
      'days': 'дн.',
      'notification_text': 'Неверный срок действия карты',
      'check_text': 'Сохранить в PDF',
      'loader_fail': 'Сбой в процессе оплаты',
      'auth_code': 'Код авторизации',
    },
    'en': {
      'order_number-text': 'Order number',
      'order_comment-text': 'Payment description',
      'order_desc-tip-link': 'Test card info',
      'payment_timer-text': 'Session time left',
      'cardnumber_label': 'Card number',
      'result_cardnumber_label': 'Card number',
      'cardholder_label': 'Cardholder name',
      'date_label': 'MM/YY',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Last three digits on the signature line',
      'contact_info-email': 'We will need your email so that we can send to you notice of payment',
      'contact_info-phone': 'We will need your phone number so that we can send to you notice of payment',
      'go_purchase': 'Payment',
      'go_credit': 'Pay on credit',
      'payment_denied': 'Payment declined',
      'payment_success': 'Payment completed successfully',
      'payment_issue': 'Payment declined',
      'result_company': 'Organisation',
      'result_date': 'Date',
      'result_number': 'Order number',
      'result_comment': 'Reason for rejection',
      'result_amount': 'Payment amount',
      'result_extra': 'Payment fee',
      'result_cancel': 'Back to Shop',
      'try_again': 'Try again',
      'go_accept': 'Back to Shop',
      'days': 'd.',
      'notification_text': 'Wrong expiration date',
      'check_text': 'Save to PDF',
      'loader_fail': 'Failure in the payment process',
      'auth_code': 'Authorization code',
    },
    'ua': {
      'order_number-text': 'Номер замовлення',
      'payment_timer-text': 'До завершення сесії залишилося',
      'order_desc-tip-link': 'Інформація про тестову картку',
      'order_comment-text': 'Опис платежу',
      'cardnumber_label': 'Номер картки',
      'result_cardnumber_label': 'Номер картки',
      'cardholder_label': 'Власник картки',
      'date_label': 'ММ/РР',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Останні 3 цифри коду на смузі для підпису',
      'contact_info-email': 'Нам знадобиться ваш email, щоб ми могли відправити на нього повідомлення про платіж',
      'contact_info-phone': 'Нам знадобиться ваш № телефону, щоб ми могли відправити на нього повідомлення про платіж',
      'go_purchase': 'Сплатити',
      'go_credit': 'Оплата у кредит',
      'payment_denied': 'Оплата відхилена',
      'payment_success': 'Платіж успішно завершений',
      'payment_issue': 'Оплата відхилена',
      'result_company': 'Організація',
      'result_date': 'Дата',
      'result_number': 'Номер замовлення',
      'result_comment': 'Причина відхилення',
      'result_amount': 'Сума платежу',
      'result_extra': 'Комісія за платіж',
      'result_cancel': 'Повернутися до магазину',
      'try_again': 'Cпробуйте ще раз',
      'go_accept': 'Повернутися до магазину',
      'days': 'дн.',
      'notification_text': 'Неправильний термін придатності',
      'check_text': 'Зберегти в форматі PDF',
      'loader_fail': 'Збій у процесі оплати',
      'auth_code': 'Код авторизації',
    },
    'de': {
      'order_number-text': 'Auftragsnummer',
      'payment_timer-text': 'Bis zum Session-Schluss bleiben',
      'order_desc-tip-link': 'Informationen zur Testkarte',
      'order_comment-text': 'Zahlungsbezeichnung',
      'cardnumber_label': 'Kartennummer',
      'result_cardnumber_label': 'Kartennummer falsch eingegeben',
      'cardholder_label': 'Karteninhaber',
      'date_label': 'MM/GG',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Drei Endziffern der Code',
      'contact_info-email': 'Wir brauchen Ihre E-Mail-Adresse, um Ihnen Zahlungsbestätigung zu schicken',
      'contact_info-phone': 'Wir brauchen Ihre Telefonnummer, um Ihnen Zahlungsbestätigung zu schicken',
      'go_purchase': 'Bezahlen',
      'go_credit': 'Auf Kredit bezahlen',
      'payment_denied': 'Zahlung abgelehnt',
      'payment_success': 'Zahlung erfolgreich abgeschlossen',
      'payment_issue': 'Zahlung abgelehnt',
      'result_company': 'Organisation',
      'result_date': 'Datum',
      'result_number': 'Auftragsnummer',
      'result_comment': 'Ablehnungsgrund',
      'result_amount': 'Zahlungsbetrag',
      'result_extra': 'Zahlungsprovision',
      'result_cancel': 'Zurück zum Shop',
      'try_again': 'Versuch es noch einmal',
      'go_accept': 'Zurück zum Shop',
      'days': 't.',
      'notification_text': 'Falsches Ablaufdatum',
      'check_text': 'Als PDF speichern',
      'loader_fail': 'Fehler beim Zahlungsvorgang',
      'auth_code': 'Autorisierungscode',
    },
    'fr': {
      'order_number-text': 'Numéro de la commande',
      'payment_timer-text': 'Il reste jusqu’à la fin de la session',
      'order_desc-tip-link': 'Informations sur la carte de test',
      'order_comment-text': 'Description',
      'cardnumber_label': 'Numéro de la carte',
      'result_cardnumber_label': 'Numéro de la carte',
      'cardholder_label': 'Le nom du détenteur',
      'date_label': 'MM/AA',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Les trois derniers chiffres du code',
      'contact_info-email': 'Nous aurons besoin de votre courriel pour pouvoir y envoyer  l’avis de paiement',
      'contact_info-phone': 'Nous aurons besoin de votre numéro de téléphone pour pouvoir y envoyer  l’avis de paiement',
      'go_purchase': 'Paiement',
      'go_credit': 'Payer à crédit',
      'payment_denied': 'Paiement rejeté',
      'payment_success': 'Paiement effectué avec succès',
      'payment_issue': 'Paiement rejeté',
      'result_company': 'Organisation',
      'result_date': 'Date',
      'result_number': 'Numéro de la commande',
      'result_comment': 'Raison du rejet',
      'result_amount': 'Montant',
      'result_extra': 'Commission',
      'result_cancel': 'Retour au magasin',
      'try_again': 'Essayer à nouveau',
      'go_accept': 'Retour au magasin',
      'days': 'd.',
      'notification_text': "Mauvaise date d'expiration",
      'check_text': 'Sauvegarder dans le format PDF',
      'loader_fail': 'Échec du processus de paiement',
      'auth_code': 'Code d’autorisation',
    },
    'es': {
      'order_number-text': 'Número del pedido',
      'payment_timer-text': 'Quedan hasta el final de la sesión',
      'order_desc-tip-link': 'Información de la tarjeta de prueba',
      'order_comment-text': 'Descripción del pago',
      'cardnumber_label': 'Número de la tarjeta',
      'result_cardnumber_label': 'Número de la tarjeta',
      'cardholder_label': 'Tenedor de la tarjeta',
      'date_label': 'Mes/Año',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Últimas 3 cifras del código sobre la raya de la firma',
      'contact_info-email': 'Necesitaremos su email para poder enviarle la notificación de pago',
      'contact_info-phone': 'Necesitaremos su № de teléfono para poder enviarle la notificación de pago',
      'go_purchase': 'Pagar',
      'go_credit': 'Pagar a crédito',
      'payment_denied': 'Pago bloqueado',
      'payment_success': 'Pago completado exitosamente',
      'payment_issue': 'Pago bloqueado',
      'result_company': 'Organizacion',
      'result_date': 'Fecha',
      'result_number': 'Número del pedido',
      'result_comment': 'Causa del bloqueo',
      'result_amount': 'Suma a paga',
      'result_extra': 'Comisión por pago',
      'result_cancel': 'Volver a la tienda',
      'try_again': 'Intentar otra vez',
      'go_accept': 'Volver a la tienda',
      'days': 'd.',
      'notification_text': "Fecha de vencimiento incorrecta",
      'check_text': 'Guardar en PDF',
      'loader_fail': 'Fallo en el proceso de pago',
      'auth_code': 'Código de la autorización\n',
    },
    'kk': {
      'order_number-text': 'Тапсырыстың нөмірі',
      'payment_timer-text': 'Сессияның аяқталуына дейін қалды',
      'order_desc-tip-link': 'Сынақ картасы туралы ақпарат',
      'order_comment-text': 'Төлемді сипаттау',
      'cardnumber_label': 'Картаның нөмірін',
      'result_cardnumber_label': 'Картаның нөмірін',
      'cardholder_label': 'Иесінің аты',
      'date_label': 'КК/ЖЖ',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Картаның кері жағындағы соңғы 3 сан',
      'contact_info-email': 'Бізге төлем туралы хабарлама жіберу үшін сіздің email керек болады',
      'contact_info-phone': 'Бізге төлем туралы хабарлама жіберу үшін сіздің телефон № керек болады',
      'go_purchase': 'Төлеу',
      'go_credit': 'Несиеге төлеу',
      'payment_denied': 'Төлем қабылданбады',
      'payment_success': 'Төлем сәтті аяқталды',
      'payment_issue': 'Төлем қабылданбады',
      'result_company': 'Ұйым',
      'result_date': 'Күні',
      'result_number': 'Тапсырыстың нөмірі',
      'result_comment': 'Қабылдамаудың себебі',
      'result_amount': 'Төлем сомасы',
      'result_extra': 'Төлем комиссиясы',
      'result_cancel': 'Дүкенге қайту',
      'try_again': 'Қайтадан байқап көріңіз',
      'go_accept': 'Дүкенге қайту',
      'days': 'к.',
      'notification_text': "Жарамдылық мерзімі дұрыс емес",
      'check_text': 'PDF-ге сақтау',
      'loader_fail': 'Төлем процесіндегі сәтсіздік',
      'auth_code': 'Авторизация коды',
    },
    'it': {
      'order_number-text': 'Numero dell\'ordine',
      'payment_timer-text': 'Fino alla fine della sessione',
      'order_desc-tip-link': 'Informazioni sulla carta di prova',
      'order_comment-text': 'Descrizione del pagamento',
      'cardnumber_label': 'Numero di carta',
      'result_cardnumber_label': 'Numero di carta',
      'cardholder_label': 'Nome del titolare',
      'date_label': 'MM/AA',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': 'Ultime  tre cifre sul retro',
      'contact_info-email': 'Avremmo bisogno della tua mail per inviare la notifica del pagamento',
      'contact_info-phone': 'Avremmo bisogno del tuo numero di telefono per inviare la notifica del pagamento',
      'go_purchase': 'Pagare',
      'go_credit': 'Paga a credito',
      'payment_denied': 'Il pagamento è rifiutato',
      'payment_success': 'Grazie per il pagamento',
      'payment_issue': 'Il pagamento è rifiutato',
      'result_company': 'Organizzazione',
      'result_date': 'Data',
      'result_number': 'Numero dell\'ordine',
      'result_comment': 'Il motivo del rifiuto',
      'result_amount': 'Importo del pagamento',
      'result_extra': 'Commissione per il pagamento',
      'result_cancel': 'Tornare al negozio',
      'try_again': 'Riprova',
      'go_accept': 'Tornare al negozio',
      'days': 'g.',
      'notification_text': "Data di scadenza errata",
      'check_text': 'Scaricare in PDF',
      'loader_fail': 'Fallimento nel processo di pagamento',
      'auth_code': 'Codice di autorizzazione',
    },
    'zh': {
      'order_number-text': '订单号',
      'payment_timer-text': '剩余会话时间',
      'order_desc-tip-link': '测试卡信息',
      'order_comment-text': '付款说明',
      'cardnumber_label': '卡号',
      'result_cardnumber_label': '卡号',
      'cardholder_label': '用户名',
      'date_label': '月/年',
      'cvv_label': 'CVV/CVC',
      'cvv_tip': '背面的最后3位数字',
      'contact_info-email': '我们需要您的电子邮箱，以便我们可以向 其发送 有关付款的通知',
      'contact_info-phone': '我们需要您的手机号码，以便我们可以向 其发送 有关付款的通知',
      'go_purchase': '支付',
      'go_credit': '信用支付',
      'payment_denied': "付款被拒绝",
      'payment_success': "感谢您的付款",
      'payment_issue': "付款被拒绝",
      'result_company': '組織',
      'result_date': '日期',
      'result_number': '订单号',
      'result_comment': "拒绝原因",
      'result_amount': "付款金额",
      'result_extra': "付款手续费",
      'result_cancel': "回到商店",
      'try_again': '再试一次',
      'go_accept': "回到商店",
      'days': '日',
      'notification_text': "失效日期错误",
      'check_text': "保存为PDF格式",
      'loader_fail': '付款過程失敗！',
      'auth_code': '授权码',
    }
  };

  var localizationErrors = {
    'ru': {
      'cardNumber': 'Номер карты указан неверно',
      'expireDateOneYear': 'Срок действия указан неверно',
      'expireDateOneMonth': 'Срок действия указан неверно',
      'cardholder': 'Владелец карты указан неверно',
      'cardcccode': 'CVV/CVC указан неверно',
      'email': 'Email указан неверно',
      'phone': 'Телефон указан неверно',
    },
    'en': {
      'cardNumber': 'The card number is incorrect',
      'expireDateOneYear': 'Expiry date is incorrect',
      'expireDateOneMonth': 'Expiry date is incorrect',
      'cardholder': 'The card holder is incorrect',
      'cardcccode': 'CVV/CVC is incorrect',
      'email': 'Email is incorrect',
      'phone': 'Phone number is incorrect',
    },
    'ua': {
      'cardNumber': 'Номер картки вказаний невірно',
      'expireDateOneYear': 'Термін дії картки зазначений неправильно',
      'expireDateOneMonth': 'Термін дії картки зазначений неправильно',
      'cardholder': 'Власник картки вказаний невірно',
      'cardcccode': 'CVC вказано невірно',
      'email': 'Email вказаний невірно',
      'phone': 'Телефон вказаний невірно',
    },
    'de': {
      'cardNumber': 'Kartennummer falsch eingegeben',
      'expireDateOneYear': 'Ablaufdatum der Karte falsch e',
      'expireDateOneMonth': 'Ablaufdatum der Karte falsch e',
      'cardholder': 'Karteninhaber nicht korrekt angegeben',
      'cardcccode': 'CVC falsch eingegeben',
      'email': 'Falsche Email-Adresse eingegeben',
      'phone': 'Falsche Telefonnummer eingegeben',
    },
    'fr': {
      'cardNumber': 'Numéro incorrect',
      'expireDateOneYear': 'Durée de valabilité de la carte incorrecte',
      'expireDateOneMonth': 'Durée de valabilité de la carte incorrecte',
      'cardholder': 'Nom incorrect',
      'cardcccode': 'Code de sûreté incorrect',
      'email': 'Le courriel indiqué est invalide',
      'phone': 'Le numéro de téléphone indiqué est invalide',
    },
    'es': {
      'cardNumber': 'Falso número indicado de la tarjeta',
      'expireDateOneYear': 'Falsa validez indicada de la tarjeta',
      'expireDateOneMonth': 'Falsa validez indicada de la tarjeta',
      'cardholder': 'Falso tenedor indicado de la tarjeta',
      'cardcccode': 'Falso CVC indicado',
      'email': 'Email está indicado incorrectamente',
      'phone': 'El número de teléfono está indicado incorrectamente',
    },
    'kk': {
      'cardNumber': 'Картаның нөмірі бұрыс көрсетілген',
      'expireDateOneYear': 'Қолданылу мерзімі бұрыс көрсетілген',
      'expireDateOneMonth': 'Қолданылу мерзімі бұрыс көрсетілген',
      'cardholder': 'Картаның иесі дұрыс көрсетілмеген',
      'cardcccode': 'CVV/CVC бұрыс көрсетілген',
      'email': 'Email бұрыс көрсетілген',
      'phone': 'Телефон № бұрыс көрсетілген',
    },
    'it': {
      'cardNumber': 'Il Numero della carta non è corretto',
      'expireDateOneYear': 'La data di scadenza non è corretta',
      'expireDateOneMonth': 'La data di scadenza non è corretta',
      'cardholder': 'Il titolare non è corretto',
      'cardcccode': 'CVV/CVC non è corretto',
      'email': 'La mail è errata',
      'phone': 'Il numero di telefono è errato',
    },
    'zh': {
      'cardNumber': '指定的卡号不正确',
      'expireDateOneYear': '指定的有效期不正确',
      'expireDateOneMonth': '指定的有效期不正确',
      'cardholder': '指定的持卡人不正确',
      'cardcccode': '指定的CVV/CVC不正确',
      'email': '指定的电子邮箱不正确',
      'phone': '指定的手机号码不正确',
    }
  }

  // observe to translate validation errors
  if(document.querySelectorAll('.input__box').length) {
    var targetNodes = document.querySelectorAll('.input__box');
    var config = {childList: true};

    var callback = function (mutationsList, observer) {
      var errors = localizationErrors[window.language];
      for (var addedLabel of mutationsList) {
        var label = $(addedLabel.addedNodes[0]);
        var labelFor = $(label).attr('for');
        var errorText = errors[labelFor];
        $(label).text(errorText);
      }
    };

    var observer = new MutationObserver(callback);
    targetNodes.forEach(node => observer.observe(node, config));
  }

  // translate error after focus
  $(".elem_input").on("focus", function () {
    if($(this).closest('.input__box').find('label.error')) {
      var errors = localizationErrors[window.language];
      var label = $(this).closest('.input__box').find('label.error')[0];
      var labelFor = $(label).attr('for');
      var errorText = errors[labelFor]
      $(label).text(errorText)
    }
  })

  // delete label.error to save translate
  $('.payment__payment-buttons #go_purchase').off('click')
  $(".payment__payment-buttons #go_purchase").on("click", function(e) {
    e.preventDefault();
    $('label.error').remove()
    $('#paymentForm').submit();
  })

  function addMobileErrors() {
    var labels = $("label.error");
    var closeErrorBlock = '<div class="error_container"><button role="button" type="button" id="close_errors" class="icon-button icon-button_size_m icon-button_theme_alfa-on-color errors-list__btn-close"><span class="icon-button__content"><span class="icon-button__icon"><span class="icon icon_size_m icon_name_close icon_theme_alfa-on-color"></span></span></span></button></div>'
    $(".error_container").remove();
    if (labels.length && labels.length > 4) {
      labels = labels.slice(0,4);
    }
    if (labels.length && labels.length <= 4) {
      $("body").append(closeErrorBlock);
      for (let i = 0; i < labels.length; i++) {
        var labelFor = labels[i].getAttribute('for');
        var cloneLabelText = localizationErrors[window.language][labelFor];
        var cloneLabel = $('<label>', {
          class: 'error mobile-error',
        }).text(cloneLabelText)
        $(".error_container").append(cloneLabel);
      }

      $("#close_errors").on("click", function () {
        $(".error_container").remove();
        $('.elem_input').removeClass('error');
      })
    }

    window.addEventListener('resize', function() {
      $('label.error').css('display', 'block')
    })
  }

  $(".payment__payment-buttons #go_purchase").on("click", addMobileErrors);
  $(".payment__payment-buttons #go_purchase").on("click", function() {
    if ($("#paymentForm").css("display") === "none") {
      $(".app > .page").css("display", "none");
      $("#loader").css("display", "flex");
    }
  })

  var validationMessages = {
    'ru': {
      'cardValid': 'Номер карты указан неверно',
      'cardTypeValid': 'Номер карты указан неверно',
      'expireDate': 'Срок действия указан неверно',
      'cardHolder': 'Владелец карты указан неверно',
      'cardRequired': 'Владелец карты указан неверно',
      'cvcLengthValid': 'CVV/CVC указан неверно',
      'email': 'Email указан неверно',
      'phone': 'Телефон указан неверно',
    },
    'en': {
      'cardValid': 'The card number is incorrect',
      'cardTypeValid': 'The card number is incorrect',
      'expireDate': 'Expiry date is incorrect',
      'cardHolder': 'The card holder is incorrect',
      'cardRequired': 'The card holder is incorrect',
      'cvcLengthValid': 'CVV/CVC is incorrect',
      'email': 'Email is incorrect',
      'phone': 'Phone number is incorrect',
    },
    'ua': {
      'cardValid': 'Номер картки вказаний невірно',
      'cardTypeValid': 'Номер картки вказаний невірно',
      'expireDate': 'Термін дії картки зазначений неправильно',
      'cardHolder': 'Власник картки вказаний невірно',
      'cardRequired': 'Власник картки вказаний невірно',
      'cvcLengthValid': 'CVC вказано невірно',
      'email': 'Email вказаний невірно',
      'phone': 'Телефон вказаний невірно',
    },
    'de': {
      'cardValid': 'Kartennummer falsch eingegeben',
      'cardTypeValid': 'Kartennummer falsch eingegeben',
      'expireDate': 'Ablaufdatum der Karte falsch e',
      'cardHolder': 'Karteninhaber nicht korrekt angegeben',
      'cardRequired': 'Karteninhaber nicht korrekt angegeben',
      'cvcLengthValid': 'CVC falsch eingegeben',
      'email': 'Falsche Email-Adresse eingegeben',
      'phone': 'Falsche Telefonnummer eingegeben',
    },
    'fr': {
      'cardValid': 'Numéro incorrect',
      'cardTypeValid': 'Numéro incorrect',
      'expireDate': 'Durée de valabilité de la carte incorrecte',
      'cardHolder': 'Nom incorrect',
      'cardRequired': 'Nom incorrect',
      'cvcLengthValid': 'Code de sûreté incorrect',
      'email': 'Le courriel indiqué est invalide',
      'phone': 'Le numéro de téléphone indiqué est invalide',
    },
    'es': {
      'cardValid': 'Falso número indicado de la tarjeta',
      'cardTypeValid': 'Falso número indicado de la tarjeta',
      'expireDate': 'Falsa validez indicada de la tarjeta',
      'cardHolder': 'Falso tenedor indicado de la tarjeta',
      'cardRequired': 'Falso tenedor indicado de la tarjeta',
      'cvcLengthValid': 'Falso CVC indicado',
      'email': 'Email está indicado incorrectamente',
      'phone': 'El número de teléfono está indicado incorrectamente',
    },
    'kk': {
      'cardValid': 'Картаның нөмірі бұрыс көрсетілген',
      'cardTypeValid': 'Картаның нөмірі бұрыс көрсетілген',
      'expireDate': 'Қолданылу мерзімі бұрыс көрсетілген',
      'cardHolder': 'Картаның иесі дұрыс көрсетілмеген',
      'cardRequired': 'Картаның иесі дұрыс көрсетілмеген',
      'cvcLengthValid': 'CVV/CVC бұрыс көрсетілген',
      'email': 'Email бұрыс көрсетілген',
      'phone': 'Телефон № бұрыс көрсетілген',
    },
    'it': {
      'cardValid': 'Il Numero della carta non è corretto',
      'cardTypeValid': 'Il Numero della carta non è corretto',
      'expireDate': 'La data di scadenza non è corretta',
      'cardHolder': 'Il titolare non è corretto',
      'cardRequired': 'Il titolare non è corretto',
      'cvcLengthValid': 'CVV/CVC non è corretto',
      'email': 'La mail è errata',
      'phone': 'Il numero di telefono è errato',
    },
    'zh': {
      'cardValid': '指定的卡号不正确',
      'cardTypeValid': '指定的卡号不正确',
      'expireDate': '指定的有效期不正确',
      'cardHolder': '指定的持卡人不正确',
      'cardRequired': '指定的持卡人不正确',
      'cvcLengthValid': '指定的CVV/CVC不正确',
      'email': '指定的电子邮箱不正确',
      'phone': '指定的手机号码不正确',
    }
  }

  changeLanguage(window.language);

  var customLocales = {
    'ru': {
      'cardNumberRequired': 'Номер карты указан неверно',
      'cardNumberInvalid': 'Номер карты указан неверно',
      'cardNumberTypeInvalid': 'Номер карты указан неверно',
      'expireDateMustBeGreater': 'Срок действия указан неверно',
      'expireDateRequired': 'Срок действия указан неверно',
      'invalidMonth': 'Срок действия указан неверно',
      'invalidYear': 'Срок действия указан неверно',
      'cardHolderRequired': 'Владелец карты указан неверно',
      'cardHolderValid': 'Владелец карты указан неверно',
      'cardHolderLength': 'Владелец карты указан неверно',
      'cvcDigitsOnly': 'CVV/CVC указан неверно',
      'cvcDigitsRequired': 'CVV/CVC указан неверно',
      'cvcDigitsLength': 'CVV/CVC указан неверно',
      'cvcInvalid': 'CVV/CVC указан неверно',
      'emailRequired': 'Email указан неверно',
      'emailInvalid': 'Email указан неверно',
      'phoneRequired': 'Телефон указан неверно',
      'phoneInvalid': 'Телефон указан неверно',
    },
    'en': {
      'cardNumberRequired': 'The card number is incorrect',
      'cardNumberInvalid': 'The card number is incorrect',
      'cardNumberTypeInvalid': 'The card number is incorrect',
      'expireDateMustBeGreater': 'Expiry date is incorrect',
      'expireDateRequired': 'Expiry date is incorrect',
      'invalidMonth': 'Expiry date is incorrect',
      'invalidYear': 'Expiry date is incorrect',
      'cardHolderRequired': 'The card holder is incorrect',
      'cardHolderValid': 'The card holder is incorrect',
      'cardHolderLength': 'The card holder is incorrect',
      'cvcDigitsOnly': 'CVV/CVC is incorrect',
      'cvcDigitsRequired': 'CVV/CVC is incorrect',
      'cvcDigitsLength': 'CVV/CVC is incorrect',
      'cvcInvalid': 'CVV/CVC is incorrect',
      'emailRequired': 'Email is incorrect',
      'emailInvalid': 'Email is incorrect',
      'phoneRequired': 'Phone number is incorrect',
      'phoneInvalid': 'Phone number is incorrect',
    },
    'ua': {
      'cardNumberRequired': 'Номер картки вказаний невірно',
      'cardNumberInvalid': 'Номер картки вказаний невірно',
      'cardNumberTypeInvalid': 'Номер картки вказаний невірно',
      'expireDateMustBeGreater': 'Термін дії картки зазначений неправильно',
      'expireDateRequired': 'Термін дії картки зазначений неправильно',
      'invalidMonth': 'Термін дії картки зазначений неправильно',
      'invalidYear': 'Термін дії картки зазначений неправильно',
      'cardHolderRequired': 'Власник картки вказаний невірно',
      'cardHolderValid': 'Власник картки вказаний невірно',
      'cardHolderLength': 'Власник картки вказаний невірно',
      'cvcDigitsOnly': 'CVC вказано невірно',
      'cvcDigitsRequired': 'CVC вказано невірно',
      'cvcDigitsLength': 'CVC вказано невірно',
      'cvcInvalid': 'CVC вказано невірно',
      'emailRequired': 'Email вказаний невірно',
      'emailInvalid': 'Email вказаний невірно',
      'phoneRequired': 'Телефон вказаний невірно',
      'phoneInvalid': 'Телефон вказаний невірно',
    },
    'de': {
      'cardNumberRequired': 'Kartennummer falsch eingegeben',
      'cardNumberInvalid': 'Kartennummer falsch eingegeben',
      'cardNumberTypeInvalid': 'Kartennummer falsch eingegeben',
      'expireDateMustBeGreater': 'Ablaufdatum der Karte falsch e',
      'expireDateRequired': 'Ablaufdatum der Karte falsch e',
      'invalidMonth': 'Ablaufdatum der Karte falsch e',
      'invalidYear': 'Ablaufdatum der Karte falsch e',
      'cardHolderRequired': 'Karteninhaber nicht korrekt angegeben',
      'cardHolderValid': 'Karteninhaber nicht korrekt angegeben',
      'cardHolderLength': 'Karteninhaber nicht korrekt angegeben',
      'cvcDigitsOnly': 'CVC falsch eingegeben',
      'cvcDigitsRequired': 'CVC falsch eingegeben',
      'cvcDigitsLength': 'CVC falsch eingegeben',
      'cvcInvalid': 'CVC falsch eingegeben',
      'emailRequired': 'Falsche Email-Adresse eingegeben',
      'emailInvalid': 'Falsche Email-Adresse eingegeben',
      'phoneRequired': 'Falsche Telefonnummer eingegeben',
      'phoneInvalid': 'Falsche Telefonnummer eingegeben',
    },
    'fr': {
      'cardNumberRequired': 'Numéro incorrect',
      'cardNumberInvalid': 'Numéro incorrect',
      'cardNumberTypeInvalid': 'Numéro incorrect',
      'expireDateMustBeGreater': 'Durée de valabilité de la carte incorrecte',
      'expireDateRequired': 'Durée de valabilité de la carte incorrecte',
      'invalidMonth': 'Durée de valabilité de la carte incorrecte',
      'invalidYear': 'Durée de valabilité de la carte incorrecte',
      'cardHolderRequired': 'Nom incorrect',
      'cardHolderValid': 'Nom incorrect',
      'cardHolderLength': 'Nom incorrect',
      'cvcDigitsOnly': 'Code de sûreté incorrect',
      'cvcDigitsRequired': 'Code de sûreté incorrect',
      'cvcDigitsLength': 'Code de sûreté incorrect',
      'cvcInvalid': 'Code de sûreté incorrect',
      'emailRequired': 'Le courriel indiqué est invalide',
      'emailInvalid': 'Le courriel indiqué est invalide',
      'phoneRequired': 'Le numéro de téléphone indiqué est invalide',
      'phoneInvalid': 'Le numéro de téléphone indiqué est invalide',
    },
    'es': {
      'cardNumberRequired': 'Falso número indicado de la tarjeta',
      'cardNumberInvalid': 'Falso número indicado de la tarjeta',
      'cardNumberTypeInvalid': 'Falso número indicado de la tarjeta',
      'expireDateMustBeGreater': 'Falsa validez indicada de la tarjeta',
      'expireDateRequired': 'Falsa validez indicada de la tarjeta',
      'invalidMonth': 'Falsa validez indicada de la tarjeta',
      'invalidYear': 'Falsa validez indicada de la tarjeta',
      'cardHolderRequired': 'Falso tenedor indicado de la tarjeta',
      'cardHolderValid': 'Falso tenedor indicado de la tarjeta',
      'cardHolderLength': 'Falso tenedor indicado de la tarjeta',
      'cvcDigitsOnly': 'Falso CVC indicado',
      'cvcDigitsRequired': 'Falso CVC indicado',
      'cvcDigitsLength': 'Falso CVC indicado',
      'cvcInvalid': 'Falso CVC indicado',
      'emailRequired': 'Email está indicado incorrectamente',
      'emailInvalid': 'Email está indicado incorrectamente',
      'phoneRequired': 'El número de teléfono está indicado incorrectamente',
      'phoneInvalid': 'El número de teléfono está indicado incorrectamente',
    },
    'kk': {
      'cardNumberRequired': 'Картаның нөмірі бұрыс көрсетілген',
      'cardNumberInvalid': 'Картаның нөмірі бұрыс көрсетілген',
      'cardNumberTypeInvalid': 'Картаның нөмірі бұрыс көрсетілген',
      'expireDateMustBeGreater': 'Қолданылу мерзімі бұрыс көрсетілген',
      'expireDateRequired': 'Қолданылу мерзімі бұрыс көрсетілген',
      'invalidMonth': 'Қолданылу мерзімі бұрыс көрсетілген',
      'invalidYear': 'Қолданылу мерзімі бұрыс көрсетілген',
      'cardHolderRequired': 'Картаның иесі дұрыс көрсетілмеген',
      'cardHolderValid': 'Картаның иесі дұрыс көрсетілмеген',
      'cardHolderLength': 'Картаның иесі дұрыс көрсетілмеген',
      'cvcDigitsOnly': 'CVV/CVC бұрыс көрсетілген',
      'cvcDigitsRequired': 'CVV/CVC бұрыс көрсетілген',
      'cvcDigitsLength': 'CVV/CVC бұрыс көрсетілген',
      'cvcInvalid': 'CVV/CVC бұрыс көрсетілген',
      'emailRequired': 'Email бұрыс көрсетілген',
      'emailInvalid': 'Email бұрыс көрсетілген',
      'phoneRequired': 'Телефон № бұрыс көрсетілген',
      'phoneInvalid': 'Телефон № бұрыс көрсетілген',
    },
    'it': {
      'cardNumberRequired': 'Il Numero della carta non è corretto',
      'cardNumberInvalid': 'Il Numero della carta non è corretto',
      'cardNumberTypeInvalid': 'Il Numero della carta non è corretto',
      'expireDateMustBeGreater': 'La data di scadenza non è corretta',
      'expireDateRequired': 'La data di scadenza non è corretta',
      'invalidMonth': 'La data di scadenza non è corretta',
      'invalidYear': 'La data di scadenza non è corretta',
      'cardHolderRequired': 'Il titolare non è corretto',
      'cardHolderValid': 'Il titolare non è corretto',
      'cardHolderLength': 'Il titolare non è corretto',
      'cvcDigitsOnly': 'CVV/CVC non è corretto',
      'cvcDigitsRequired': 'CVV/CVC non è corretto',
      'cvcDigitsLength': 'CVV/CVC non è corretto',
      'cvcInvalid': 'CVV/CVC non è corretto',
      'emailRequired': 'La mail è errata',
      'emailInvalid': 'La mail è errata',
      'phoneRequired': 'Il numero di telefono è errato',
      'phoneInvalid': 'Il numero di telefono è errato',
    },
    'zh': {
      'cardNumberRequired': '指定的卡号不正确',
      'cardNumberInvalid': '指定的卡号不正确',
      'cardNumberTypeInvalid': '指定的卡号不正确',
      'expireDateMustBeGreater': '指定的有效期不正确',
      'expireDateRequired': '指定的有效期不正确',
      'invalidMonth': '指定的有效期不正确',
      'invalidYear': '指定的有效期不正确',
      'cardHolderRequired': '指定的持卡人不正确',
      'cardHolderValid': '指定的持卡人不正确',
      'cardHolderLength': '指定的持卡人不正确',
      'cvcDigitsOnly': '指定的CVV/CVC不正确',
      'cvcDigitsRequired': '指定的CVV/CVC不正确',
      'cvcDigitsLength': '指定的CVV/CVC不正确',
      'cvcInvalid': '指定的CVV/CVC不正确',
      'emailRequired': '指定的电子邮箱不正确',
      'emailInvalid': '指定的电子邮箱不正确',
      'phoneRequired': '指定的手机号码不正确',
      'phoneInvalid': '指定的手机号码不正确',
    }
  }

  if (window.order_timeout > 0) {
    var intervalId;
    $('#payment_timer-value').html(toDDHHMMSS(window.timestamp_order_time - parseInt(new Date().getTime()/1000)))
    intervalId = setInterval(function () {
        $('.payment_timer-value').html(toDDHHMMSS(window.timestamp_order_time - parseInt(new Date().getTime()/1000)));
        if (window.timestamp_order_time - parseInt(new Date().getTime()/1000) < 1) {
          clearInterval(intervalId);
        }
      }, 1000);
  }

  window.locales = $.extend(true, window.locales, customLocales);

  var reasonMap = {
    'ru': {
      '3dsecure/reject': "Операция невозможна. Аутентификация держателя карты завершена неуспешно.",
      '3dsecure/failed': "Операция невозможна. Аутентификация держателя карты завершена неуспешно.",
      '3dsecure/timeout': "Операция невозможна. Аутентификация держателя карты завершена неуспешно.",
      '3dsecure/network': "Операция невозможна. Аутентификация держателя карты завершена неуспешно.",
      'system/ok': "",
      'bank/common': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/fraud': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/network': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/funds': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/account': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/limit': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'bank/timeout': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/black-list': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/max_attempts': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/in_progress': "",
      'system/network': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/fraud': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/unavailable_method': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/operator': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/common': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/timeout': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/session': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/denied': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/already_processed': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'system/cancel_denied': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/timeout': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/cancel': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/duplicate': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/network': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/card_not_binded': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/unsupported_card': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'user/interaction_timeout': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
      'default': "Операция отклонена. Проверьте введенные данные, достаточность средств на счёте и повторите операцию.",
    },
    'en': {
      '3dsecure/reject': "Operation is not possible. Cardholder authentication failed.",
      '3dsecure/failed': "Operation is not possible. Cardholder authentication failed.",
      '3dsecure/timeout': "Operation is not possible. Cardholder authentication failed.",
      '3dsecure/network': "Operation is not possible. Cardholder authentication failed.",
      'system/ok': "",
      'bank/common': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/fraud': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/network': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/funds': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/account': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/limit': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'bank/timeout': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/black-list': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/max_attempts': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/in_progress': "",
      'system/network': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/fraud': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/unavailable_method': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/operator': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/common': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/timeout': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/session': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/denied': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/already_processed': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'system/cancel_denied': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/timeout': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/cancel': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/duplicate': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/network': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/card_not_binded': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/unsupported_card': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'user/interaction_timeout': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
      'default': "Operation rejected. Check the entered data, the sufficiency of funds on the account and repeat the operation.",
    },
    'ua': {
      '3dsecure/reject': "Операція неможлива. Аутентифікація власника картки завершена неуспішно.",
      '3dsecure/failed': "Операція неможлива. Аутентифікація власника картки завершена неуспішно.",
      '3dsecure/timeout': "Операція неможлива. Аутентифікація власника картки завершена неуспішно.",
      '3dsecure/network': "Операція неможлива. Аутентифікація власника картки завершена неуспішно.",
      'system/ok': "",
      'bank/common': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/fraud': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/network': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/funds': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/account': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/limit': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'bank/timeout': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/black-list': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/max_attempts': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/in_progress': "",
      'system/network': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/fraud': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/unavailable_method': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/operator': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/common': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/timeout': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/session': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/denied': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/already_processed': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'system/cancel_denied': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/timeout': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/cancel': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/duplicate': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/network': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/card_not_binded': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/unsupported_card': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'user/interaction_timeout': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
      'default': "Операцію відхилено. Перевірте введені дані, достатність коштів на рахунку та повторіть операцію.",
    },
    'de': {
      '3dsecure/reject': "Betrieb ist nicht möglich. Authentifizierung des Karteninhabers fehlgeschlagen.",
      '3dsecure/failed': "Betrieb ist nicht möglich. Authentifizierung des Karteninhabers fehlgeschlagen.",
      '3dsecure/timeout': "Betrieb ist nicht möglich. Authentifizierung des Karteninhabers fehlgeschlagen.",
      '3dsecure/network': "Betrieb ist nicht möglich. Authentifizierung des Karteninhabers fehlgeschlagen.",
      'system/ok': "",
      'bank/common': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/fraud': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/network': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/funds': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/account': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/limit': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'bank/timeout': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/black-list': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/max_attempts': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/in_progress': "",
      'system/network': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/fraud': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/unavailable_method': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/operator': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/common': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/timeout': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/session': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/denied': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/already_processed': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'system/cancel_denied': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/timeout': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/cancel': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/duplicate': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/network': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/card_not_binded': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/unsupported_card': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'user/interaction_timeout': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
      'default': "Vorgang abgelehnt. Überprüfen Sie die eingegebenen Daten, die ausreichende Deckung des Kontos und wiederholen Sie den Vorgang.",
    },
    'fr': {
      '3dsecure/reject': "L'opération n'est pas possible. L'authentification du titulaire de la carte a échoué.",
      '3dsecure/failed': "L'opération n'est pas possible. L'authentification du titulaire de la carte a échoué.",
      '3dsecure/timeout': "L'opération n'est pas possible. L'authentification du titulaire de la carte a échoué.",
      '3dsecure/network': "L'opération n'est pas possible. L'authentification du titulaire de la carte a échoué.",
      'system/ok': "",
      'bank/common': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/fraud': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/network': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/funds': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/account': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/limit': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'bank/timeout': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/black-list': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/max_attempts': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/in_progress': "",
      'system/network': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/fraud': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/unavailable_method': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/operator': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/common': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/timeout': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/session': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/denied': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/already_processed': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'system/cancel_denied': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/timeout': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/cancel': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/duplicate': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/network': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/card_not_binded': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/unsupported_card': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'user/interaction_timeout': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
      'default': "Opération refusée. Vérifiez les données saisies, la suffisance des fonds sur le compte et répétez l'opération.",
    },
    'es': {
      '3dsecure/reject': "La operación no es posible. La autenticación del titular de la tarjeta falló.",
      '3dsecure/failed': "La operación no es posible. La autenticación del titular de la tarjeta falló.",
      '3dsecure/timeout': "La operación no es posible. La autenticación del titular de la tarjeta falló.",
      '3dsecure/network': "La operación no es posible. La autenticación del titular de la tarjeta falló.",
      'system/ok': "",
      'bank/common': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/fraud': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/network': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/funds': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/account': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/limit': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'bank/timeout': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/black-list': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/max_attempts': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/in_progress': "",
      'system/network': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/fraud': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/unavailable_method': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/operator': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/common': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/timeout': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/session': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/denied': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/already_processed': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'system/cancel_denied': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/timeout': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/cancel': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/duplicate': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/network': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/card_not_binded': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/unsupported_card': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'user/interaction_timeout': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
      'default': "Operación rechazada. Verifique los datos ingresados, la suficiencia de fondos en la cuenta y repita la operación.",
    },
    'kk': {
      '3dsecure/reject': "Операция мүмкін емес. Карта иесінің аутентификациясы орындалмады.",
      '3dsecure/failed': "Операция мүмкін емес. Карта иесінің аутентификациясы орындалмады.",
      '3dsecure/timeout': "Операция мүмкін емес. Карта иесінің аутентификациясы орындалмады.",
      '3dsecure/network': "Операция мүмкін емес. Карта иесінің аутентификациясы орындалмады.",
      'system/ok': "",
      'bank/common': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/fraud': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/network': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/funds': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/account': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/limit': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'bank/timeout': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/black-list': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/max_attempts': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/in_progress': "",
      'system/network': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/fraud': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/unavailable_method': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/operator': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/common': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/timeout': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/session': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/denied': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/already_processed': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'system/cancel_denied': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/timeout': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/cancel': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/duplicate': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/network': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/card_not_binded': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/unsupported_card': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'user/interaction_timeout': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
      'default': "Операция қабылданбады. Енгізілген деректерді, шоттағы қаражаттың жеткіліктілігін тексеріп, операцияны қайталаңыз.",
    },
    'it': {
      '3dsecure/reject': "L'operazione non è possibile. Autenticazione del titolare della carta non riuscita.",
      '3dsecure/failed': "L'operazione non è possibile. Autenticazione del titolare della carta non riuscita.",
      '3dsecure/timeout': "L'operazione non è possibile. Autenticazione del titolare della carta non riuscita.",
      '3dsecure/network': "L'operazione non è possibile. Autenticazione del titolare della carta non riuscita.",
      'system/ok': "",
      'bank/common': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/fraud': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/network': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/funds': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/account': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/limit': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'bank/timeout': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/black-list': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/max_attempts': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/in_progress': "",
      'system/network': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/fraud': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/unavailable_method': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/operator': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/common': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/timeout': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/session': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/denied': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/already_processed': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'system/cancel_denied': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/timeout': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/cancel': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/duplicate': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/network': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/card_not_binded': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/unsupported_card': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'user/interaction_timeout': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
      'default': "Operazione rifiutata. Controlla i dati inseriti, la sufficienza dei fondi sul conto e ripeti l'operazione.",
    },
    'zh': {
      '3dsecure/reject': "无法操作。 持卡人身份验证失败。",
      '3dsecure/failed': "无法操作。 持卡人身份验证失败。",
      '3dsecure/timeout': "无法操作。 持卡人身份验证失败。",
      '3dsecure/network': "无法操作。 持卡人身份验证失败。",
      'system/ok': "",
      'bank/common': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/fraud': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/network': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/funds': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/account': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/limit': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'bank/timeout': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/black-list': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/max_attempts': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/in_progress': "",
      'system/network': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/fraud': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/unavailable_method': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/operator': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/common': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/timeout': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/session': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/denied': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/already_processed': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'system/cancel_denied': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/timeout': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/cancel': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/duplicate': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/network': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/card_not_binded': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/unsupported_card': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'user/interaction_timeout': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
      'default': "操作被拒绝。 检查输入的数据，账户上的资金是否充足，然后重复操作。",
    },
  }

  function getReason(error) {
    var lang = window.language;
    try {
      return reasonMap[lang][error.category + '/' + error.code];
    } catch (e) {
      return reasonMap[lang]['default'];
    }
  }


  window.egopay._callback = function (data) {
    if (data.payments.length) {
      var payments = data.payments[0];
      var tdate = new Date(payments.tdate);
      var date = ('0' + tdate.getDate()).slice(-2) + '.' + ('0' + String(Number(tdate.getMonth()) + 1)).slice(-2) + '.' + tdate.getFullYear() + ' ' + ('0' + tdate.getHours()).slice(-2) + ':' + ('0' + tdate.getMinutes()).slice(-2) + ':' + ('0' + tdate.getSeconds()).slice(-2);
      var format_card_number = payments.card_number.replace('*', '**');
      $('.tdate').text(date);
      $('.reason').text(getReason(data.error));
      window.decline_reason = data.error;
      $('.auth_code_value').text(payments.auth_code);
      $('.cardnumber').text(format_card_number);
      var cardholder = payments.holder || '';
      $('.cardholder').text(cardholder.toUpperCase());
    }
    if (!data.success) {
      if (window.egopay._elements.error) {
        if (data.comment) {
          window.egopay._elements.error.find('p').show().text(data.comment);
        } else {
          window.egopay._elements.error.find('p').hide();
        }
        window.egopay.showElement('error');
      }
      if (window.egopay._elements.loader) {
        window.egopay._elements.loader.hide();
      }
      if (window.egopay._elements.fail) {
        window.egopay._elements.fail.hide();
      }
      if (window.egopay._elements.issue) {
        window.egopay._elements.issue.hide();
      }
    } else {

      if (window.egopay._elements.error) {
        window.egopay._elements.error.hide();
      }
      if (window.egopay._elements.loader) {
        window.egopay._elements.loader.hide();
      }
      if (window.egopay._elements.fail) {
        window.egopay._elements.fail.hide();
      }
      if (window.egopay._elements.issue) {
        window.egopay._elements.issue.hide();
      }
      window.egopay.showElement('success');
    }
  };

  if (window.answer && window.answer.success !== null && window.answer.status !== null){
    window.egopay._callback(window.answer);
  }
  if ($.validator){
    $.validator.addMethod('expireDateNotFull',
      function() {
        var dateString = $('#expiredate').val();
        return dateString.length === 5;
      },
      window.egopay.locale.invalidMonth
    );
    $.validator.addClassRules('input-expire-one', {
      expireDateNotFull: true,
    });
  }
})
